/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.DelegatingTransaction;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.TransactionPayload;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.RelativePath;

public interface Transaction<E> {
    public InventoryBackend<E> directAccess();

    public void registerCommittedPayload(TransactionPayload.Committing<?, E> var1);

    public PreCommit<E> getPreCommit();

    public <T> T convert(E var1, Class<T> var2);

    public void delete(E var1);

    public void deleteStructuredData(E var1);

    public E descendToData(E var1, RelativePath var2);

    public CanonicalPath extractCanonicalPath(E var1);

    public String extractId(E var1);

    public String extractIdentityHash(E var1);

    public String extractContentHash(E var1);

    public String extractSyncHash(E var1);

    public String extractRelationshipName(E var1);

    public Class<?> extractType(E var1);

    public E find(CanonicalPath var1) throws ElementNotFoundException;

    public InputStream getGraphSON(String var1);

    public E getRelationship(E var1, E var2, String var3) throws ElementNotFoundException;

    public Set<E> getRelationships(E var1, Relationships.Direction var2, String ... var3);

    public E getRelationshipSource(E var1);

    public E getRelationshipTarget(E var1);

    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath var1, Relationships.Direction var2, Class<T> var3, String ... var4);

    public Iterator<E> getTransitiveClosureOver(E var1, Relationships.Direction var2, String ... var3);

    public boolean hasRelationship(E var1, Relationships.Direction var2, String var3);

    public boolean hasRelationship(E var1, E var2, String var3);

    public boolean isBackendInternal(E var1);

    public boolean isUniqueIndexSupported();

    public E persist(CanonicalPath var1, Blueprint var2);

    public E persist(StructuredData var1);

    public Page<E> query(Query var1, Pager var2);

    public <T> Page<T> query(Query var1, Pager var2, Function<E, T> var3, Function<T, Boolean> var4);

    public E querySingle(Query var1);

    public E relate(E var1, E var2, String var3, Map<String, Object> var4);

    public Page<E> traverse(E var1, Query var2, Pager var3);

    public E traverseToSingle(E var1, Query var2);

    public void update(E var1, AbstractElement.Update var2);

    public void updateHashes(E var1, Hashes var2);

    default public boolean requiresRollbackAfterFailure(Throwable t) {
        return true;
    }

    default public boolean isTransactionRetryWarranted(Throwable t) {
        return false;
    }

    public static class Committable<E>
    extends DelegatingTransaction<E>
    implements Transaction<E> {
        public static <E> Committable<E> from(Transaction<E> tx) {
            return new Committable<E>(tx);
        }

        protected Committable(Transaction<E> tx) {
            super(tx);
        }

        public void commit() throws CommitFailureException {
            this.getPreCommit().getActions().forEach(a -> a.accept(this));
            this.directAccess().commit();
        }

        public void rollback() {
            this.directAccess().rollback();
        }
    }

    public static interface PreCommit<E> {
        public List<EntityAndPendingNotifications<E, ?>> getFinalNotifications();

        public void initialize(Inventory var1, Transaction<E> var2);

        public void reset();

        public void addAction(Consumer<Transaction<E>> var1);

        public List<Consumer<Transaction<E>>> getActions();

        public void addNotifications(EntityAndPendingNotifications<E, ?> var1);

        public void addProcessedNotifications(EntityAndPendingNotifications<E, ?> var1);

        public static class Simple<E>
        implements PreCommit<E> {
            private List<EntityAndPendingNotifications<E, ?>> notifs = new ArrayList();
            private List<Consumer<Transaction<E>>> actions = new ArrayList<Consumer<Transaction<E>>>();
            protected Transaction<E> transaction;
            protected Inventory inventory;

            @Override
            public void initialize(Inventory inventory, Transaction<E> tx) {
                this.inventory = inventory;
                this.transaction = tx;
            }

            @Override
            public void reset() {
                this.notifs.clear();
                this.actions.clear();
            }

            @Override
            public void addNotifications(EntityAndPendingNotifications<E, ?> element) {
                this.notifs.add(element);
            }

            @Override
            public void addProcessedNotifications(EntityAndPendingNotifications<E, ?> element) {
                this.notifs.add(element);
            }

            @Override
            public void addAction(Consumer<Transaction<E>> action) {
                this.actions.add(action);
            }

            @Override
            public List<Consumer<Transaction<E>>> getActions() {
                return this.actions;
            }

            @Override
            public List<EntityAndPendingNotifications<E, ?>> getFinalNotifications() {
                return this.notifs;
            }
        }
    }
}

