/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.io.File;
import java.util.List;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class AbsolutePathService
extends AbstractPathService {
    private final String absolutePath;

    public static ServiceController<String> addService(String name, String abstractPath, ServiceTarget serviceTarget) {
        return AbsolutePathService.addService(AbsolutePathService.pathNameOf(name), abstractPath, serviceTarget, null, new ServiceListener[0]);
    }

    public static ServiceController<String> addService(String name, String abstractPath, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceListener ... listeners) {
        return AbsolutePathService.addService(AbsolutePathService.pathNameOf(name), abstractPath, serviceTarget, newControllers, listeners);
    }

    public static ServiceController<String> addService(ServiceName sname, String abstractPath, ServiceTarget serviceTarget) {
        return AbsolutePathService.addService(sname, abstractPath, serviceTarget, null, new ServiceListener[0]);
    }

    public static ServiceController<String> addService(ServiceName sname, String abstractPath, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceListener ... listeners) {
        AbsolutePathService service = new AbsolutePathService(abstractPath);
        ServiceBuilder builder = serviceTarget.addService(sname, (Service)service);
        if (listeners != null) {
            for (ServiceListener listener : listeners) {
                builder.addListener(listener);
            }
        }
        ServiceController svc = builder.install();
        if (newControllers != null) {
            newControllers.add(svc);
        }
        return svc;
    }

    public static String convertPath(String abstractPath) {
        if (abstractPath == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("abstractPath");
        }
        if (abstractPath.length() == 0) {
            throw ControllerLogger.ROOT_LOGGER.emptyVar("abstractPath");
        }
        File f = new File(abstractPath);
        return f.getAbsolutePath();
    }

    public static void addService(ServiceName name, ModelNode element, ServiceTarget serviceTarget) {
        String path = element.require("path").asString();
        AbsolutePathService.addService(name, path, serviceTarget, null, new ServiceListener[0]);
    }

    public AbsolutePathService(String abstractPath) {
        this.absolutePath = AbsolutePathService.convertPath(abstractPath);
    }

    @Override
    protected String resolvePath() {
        return this.absolutePath;
    }
}

