/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageImpl;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveClientLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;

public class ClientPacketDecoder
extends PacketDecoder {
    private static final long serialVersionUID = 6952614096979334582L;
    public static final ClientPacketDecoder INSTANCE = new ClientPacketDecoder();

    @Override
    public Packet decode(ActiveMQBuffer in) {
        byte packetType = in.readByte();
        Packet packet = this.decode(packetType);
        packet.decode(in);
        return packet;
    }

    @Override
    public Packet decode(byte packetType) {
        Packet packet;
        switch (packetType) {
            case 75: {
                packet = new SessionReceiveMessage(new ClientMessageImpl());
                break;
            }
            case 76: {
                packet = new SessionReceiveClientLargeMessage(new ClientLargeMessageImpl());
                break;
            }
            default: {
                packet = super.decode(packetType);
            }
        }
        return packet;
    }
}

