/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import org.hibernate.cache.internal.OldCacheKeyImplementation;
import org.hibernate.cache.internal.OldNaturalIdCacheKey;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultCacheKeysFactory {
    public static CacheKeysFactory INSTANCE = new CacheKeysFactory(){

        @Override
        public Object createCollectionKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
            return DefaultCacheKeysFactory.createCollectionKey(id, persister, factory, tenantIdentifier);
        }

        @Override
        public Object createEntityKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
            return DefaultCacheKeysFactory.createEntityKey(id, persister, factory, tenantIdentifier);
        }

        @Override
        public Object createNaturalIdKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
            return DefaultCacheKeysFactory.createNaturalIdKey(naturalIdValues, persister, session);
        }

        @Override
        public Object getEntityId(Object cacheKey) {
            return DefaultCacheKeysFactory.getEntityId(cacheKey);
        }

        @Override
        public Object getCollectionId(Object cacheKey) {
            return DefaultCacheKeysFactory.getCollectionId(cacheKey);
        }

        @Override
        public Object[] getNaturalIdValues(Object cacheKey) {
            return DefaultCacheKeysFactory.getNaturalIdValues(cacheKey);
        }
    };

    public static Object createCollectionKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return new OldCacheKeyImplementation(id, persister.getKeyType(), persister.getRole(), tenantIdentifier, factory);
    }

    public static Object createEntityKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return new OldCacheKeyImplementation(id, persister.getIdentifierType(), persister.getRootEntityName(), tenantIdentifier, factory);
    }

    public static Object createNaturalIdKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return new OldNaturalIdCacheKey(naturalIdValues, persister.getPropertyTypes(), persister.getNaturalIdentifierProperties(), persister.getRootEntityName(), session);
    }

    public static Object getEntityId(Object cacheKey) {
        return ((OldCacheKeyImplementation)cacheKey).getId();
    }

    public static Object getCollectionId(Object cacheKey) {
        return ((OldCacheKeyImplementation)cacheKey).getId();
    }

    public static Object[] getNaturalIdValues(Object cacheKey) {
        return ((OldNaturalIdCacheKey)cacheKey).getNaturalIdValues();
    }
}

