/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.util;

import java.nio.charset.Charset;

public final class Charsets {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset LATIN_1 = Charset.forName("8859_1");

    public static boolean encodeTo(String src, byte[] dest, int offs) {
        int srcLen = src.length();
        try {
            int i = 0;
            while (i < srcLen) {
                int cp = src.codePointAt(i);
                if (cp > 0 && cp <= 127) {
                    dest[offs++] = (byte)cp;
                } else if (cp <= 2047) {
                    dest[offs++] = (byte)(0xC0 | 0x1F & cp >> 6);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp);
                } else if (cp <= 65535) {
                    dest[offs++] = (byte)(0xE0 | 0xF & cp >> 12);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 6);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp);
                } else if (cp <= 0x1FFFFF) {
                    dest[offs++] = (byte)(0xF0 | 7 & cp >> 18);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 12);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 6);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp);
                } else if (cp <= 0x3FFFFFF) {
                    dest[offs++] = (byte)(0xF8 | 3 & cp >> 24);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 18);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 12);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 6);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp);
                } else if (cp >= 0) {
                    dest[offs++] = (byte)(0xFC | 1 & cp >> 30);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 24);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 18);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 12);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp >> 6);
                    dest[offs++] = (byte)(0x80 | 0x3F & cp);
                } else {
                    dest[offs++] = 63;
                }
                i = src.offsetByCodePoints(i, 1);
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static int encodedLengthOf(String src) {
        int srcLen = src.length();
        int l = 0;
        int i = 0;
        while (i < srcLen) {
            int cp = src.codePointAt(i);
            l = cp > 0 && cp <= 127 ? ++l : (cp <= 2047 ? (l += 2) : (cp <= 65535 ? (l += 3) : (cp <= 0x1FFFFF ? (l += 4) : (cp <= 0x3FFFFFF ? (l += 5) : (cp >= 0 ? (l += 6) : ++l)))));
            i = src.offsetByCodePoints(i, 1);
        }
        return l;
    }

    public static int indexOf(byte[] array, int search, int offs, int len) {
        for (int i = 0; i < len; ++i) {
            if (array[offs + i] != (byte)search) continue;
            return offs + i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int search, int offs) {
        return Charsets.indexOf(array, search, offs, array.length - offs);
    }

    public static int indexOf(byte[] array, int search) {
        return Charsets.indexOf(array, search, 0, array.length);
    }

    private Charsets() {
    }
}

