/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import okio.BufferedSink;
import org.hawkular.agent.monitor.cmd.AddDatasourceCommand;
import org.hawkular.agent.monitor.cmd.AddJdbcDriverCommand;
import org.hawkular.agent.monitor.cmd.Command;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.cmd.DeployApplicationCommand;
import org.hawkular.agent.monitor.cmd.DisableApplicationCommand;
import org.hawkular.agent.monitor.cmd.EchoCommand;
import org.hawkular.agent.monitor.cmd.EnableApplicationCommand;
import org.hawkular.agent.monitor.cmd.ExecuteOperationCommand;
import org.hawkular.agent.monitor.cmd.ExportJdrCommand;
import org.hawkular.agent.monitor.cmd.GenericErrorResponseCommand;
import org.hawkular.agent.monitor.cmd.RemoveDatasourceCommand;
import org.hawkular.agent.monitor.cmd.RemoveJdbcDriverCommand;
import org.hawkular.agent.monitor.cmd.RestartApplicationCommand;
import org.hawkular.agent.monitor.cmd.StatisticsControlCommand;
import org.hawkular.agent.monitor.cmd.UndeployApplicationCommand;
import org.hawkular.agent.monitor.cmd.UpdateCollectionIntervalsCommand;
import org.hawkular.agent.monitor.cmd.UpdateDatasourceCommand;
import org.hawkular.agent.monitor.cmd.WebSocketClientBuilder;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ApiDeserializer;
import org.hawkular.cmdgw.api.AuthMessage;
import org.hawkular.cmdgw.api.Authentication;
import org.hawkular.cmdgw.api.GenericErrorResponse;
import org.hawkular.cmdgw.api.GenericErrorResponseBuilder;

public class FeedCommProcessor
implements WebSocketListener {
    private static final MsgLogger log = AgentLoggers.getLogger(FeedCommProcessor.class);
    private static final Map<String, Class<? extends Command<?, ?>>> VALID_COMMANDS = new HashMap();
    private final int disconnectCode = 1000;
    private final String disconnectReason = "Shutting down FeedCommProcessor";
    private final WebSocketClientBuilder webSocketClientBuilder;
    private final MonitorServiceConfiguration config;
    private final MonitorService discoveryService;
    private final String feedcommUrl;
    private final ExecutorService sendExecutor = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService pingExecutor = Executors.newScheduledThreadPool(1);
    private final AtomicReference<ReconnectJobThread> reconnectJobThread = new AtomicReference();
    private WebSocketCall webSocketCall;
    private WebSocket webSocket;
    private ScheduledFuture<?> pingFuture;
    private boolean destroyed = false;

    public FeedCommProcessor(WebSocketClientBuilder webSocketClientBuilder, MonitorServiceConfiguration config, String feedId, MonitorService discoveryService) {
        if (feedId == null || feedId.isEmpty()) {
            throw new IllegalArgumentException("Must have a valid feed ID to communicate with the server");
        }
        this.webSocketClientBuilder = webSocketClientBuilder;
        this.config = config;
        this.discoveryService = discoveryService;
        try {
            StringBuilder url = Util.getContextUrlString(config.getStorageAdapter().getUrl(), config.getStorageAdapter().getFeedcommContext());
            url.append("feed/").append(feedId);
            this.feedcommUrl = url.toString().replaceFirst("https?:", config.getStorageAdapter().isUseSSL() ? "wss:" : "ws:");
            log.infoFeedCommUrl(this.feedcommUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot build URL to the server command-gateway endpoint", e);
        }
    }

    public boolean isConnected() {
        return this.webSocket != null;
    }

    public void connect() throws Exception {
        this.disconnect();
        if (this.destroyed) {
            return;
        }
        log.debugf("About to connect a feed WebSocket client to endpoint [%s]", this.feedcommUrl);
        this.webSocketCall = this.webSocketClientBuilder.createWebSocketCall(this.feedcommUrl, null);
        this.webSocketCall.enqueue((WebSocketListener)this);
    }

    public void disconnect() {
        this.disconnect(1000, "Shutting down FeedCommProcessor");
    }

    private void disconnect(int code, String reason) {
        if (this.webSocket != null) {
            try {
                this.webSocket.close(code, reason);
            }
            catch (Exception e) {
                log.warnFailedToCloseWebSocket(code, reason, e);
            }
            this.webSocket = null;
        }
        if (this.webSocketCall != null) {
            try {
                this.webSocketCall.cancel();
            }
            catch (Exception e) {
                log.errorCannotCloseWebSocketCall(e);
            }
            this.webSocketCall = null;
        }
    }

    public void destroy() {
        log.debugf("Destroying FeedCommProcessor", new Object[0]);
        this.destroyed = true;
        this.stopReconnectJobThread();
        this.disconnect();
        this.destroyPingExecutor();
    }

    public void sendAsync(final BasicMessageWithExtraData<? extends BasicMessage> messageWithData) {
        if (this.webSocket == null) {
            throw new IllegalStateException("WebSocket connection was closed. Cannot send any messages");
        }
        final BasicMessage message = messageWithData.getBasicMessage();
        this.configurationAuthentication(message);
        this.sendExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (messageWithData.getBinaryData() == null) {
                        String messageString = ApiDeserializer.toHawkularFormat((BasicMessage)message);
                        Buffer buffer = new Buffer().writeUtf8(messageString);
                        RequestBody requestBody = RequestBody.create((MediaType)WebSocket.TEXT, (byte[])buffer.readByteArray());
                        FeedCommProcessor.this.webSocket.sendMessage(requestBody);
                    } else {
                        final BinaryData messageData = ApiDeserializer.toHawkularFormat((BasicMessage)message, (InputStream)messageWithData.getBinaryData());
                        RequestBody requestBody = new RequestBody(){

                            public MediaType contentType() {
                                return WebSocket.BINARY;
                            }

                            public void writeTo(BufferedSink bufferedSink) throws IOException {
                                FeedCommProcessor.this.emitToSink(messageData, bufferedSink);
                            }
                        };
                        FeedCommProcessor.this.webSocket.sendMessage(requestBody);
                    }
                }
                catch (Throwable t) {
                    log.errorFailedToSendOverFeedComm(message.getClass().getName(), t);
                }
            }
        });
    }

    public void sendSync(BasicMessageWithExtraData<? extends BasicMessage> messageWithData) throws Exception {
        if (this.webSocket == null) {
            throw new IllegalStateException("WebSocket connection was closed. Cannot send any messages");
        }
        BasicMessage message = messageWithData.getBasicMessage();
        this.configurationAuthentication(message);
        if (messageWithData.getBinaryData() == null) {
            String messageString = ApiDeserializer.toHawkularFormat((BasicMessage)message);
            Buffer buffer = new Buffer().writeUtf8(messageString);
            RequestBody requestBody = RequestBody.create((MediaType)WebSocket.TEXT, (byte[])buffer.readByteArray());
            this.webSocket.sendMessage(requestBody);
        } else {
            final BinaryData messageData = ApiDeserializer.toHawkularFormat((BasicMessage)message, (InputStream)messageWithData.getBinaryData());
            RequestBody requestBody = new RequestBody(){

                public MediaType contentType() {
                    return WebSocket.BINARY;
                }

                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    FeedCommProcessor.this.emitToSink(messageData, bufferedSink);
                }
            };
            this.webSocket.sendMessage(requestBody);
        }
    }

    private void emitToSink(BinaryData in, BufferedSink out) throws RuntimeException {
        int bufferSize = 32768;
        try {
            BufferedInputStream input = new BufferedInputStream((InputStream)in, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = ((InputStream)input).read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                out.flush();
                bytesRead = ((InputStream)input).read(buffer);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to emit to sink", ioe);
        }
    }

    public void onOpen(WebSocket webSocket, Response response) {
        if (response != null && response.body() != null) {
            try {
                response.body().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stopReconnectJobThread();
        this.webSocket = webSocket;
        this.startPinging();
        log.infoOpenedFeedComm(this.feedcommUrl);
    }

    public void onClose(int reasonCode, String reason) {
        this.stopPinging();
        this.webSocket = null;
        log.infoClosedFeedComm(this.feedcommUrl, reasonCode, reason);
        if (1000 != reasonCode || !"Shutting down FeedCommProcessor".equals(reason)) {
            switch (reasonCode) {
                case 1008: {
                    break;
                }
                default: {
                    this.startReconnectJobThread();
                }
            }
        }
    }

    public void onFailure(IOException e, Response response) {
        if (response == null) {
            if (e instanceof ConnectException) {
                log.tracef("Feed communications had a failure - a reconnection is likely required: %s", e);
            } else if (e.getMessage() != null && e.getMessage().toLowerCase().contains("socket closed")) {
                log.debugf("Feed communications channel has been shutdown: " + e, new Object[0]);
            } else {
                log.warnFeedCommFailure("<null>", e);
            }
        } else {
            log.warnFeedCommFailure(response.toString(), e);
            if (response.body() != null) {
                try {
                    response.body().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.reconnectJobThread.get() == null) {
            this.stopPinging();
            this.disconnect();
            this.startReconnectJobThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ResponseBody responseBody) throws IOException {
        BasicMessageWithExtraData response;
        String requestClassName = "?";
        try {
            try {
                BasicMessageWithExtraData msgWithData;
                if (responseBody.contentType().equals((Object)WebSocket.TEXT)) {
                    String nameAndJsonStr = responseBody.string();
                    msgWithData = new ApiDeserializer().deserialize(nameAndJsonStr);
                } else if (responseBody.contentType().equals((Object)WebSocket.BINARY)) {
                    InputStream input = responseBody.byteStream();
                    msgWithData = new ApiDeserializer().deserialize(input);
                } else {
                    throw new IllegalArgumentException("Unknown mediatype type, please report this bug: " + responseBody.contentType());
                }
                log.debug("Received message from server");
                BasicMessage msg = msgWithData.getBasicMessage();
                requestClassName = msg.getClass().getName();
                Class<Command<?, ?>> commandClass = VALID_COMMANDS.get(requestClassName);
                if (commandClass == null) {
                    log.errorInvalidCommandRequestFeed(requestClassName);
                    String errorMessage = "Invalid command request: " + requestClassName;
                    GenericErrorResponse errorMsg = new GenericErrorResponseBuilder().setErrorMessage(errorMessage).build();
                    response = new BasicMessageWithExtraData((BasicMessage)errorMsg, null);
                } else {
                    Command<?, ?> command = commandClass.newInstance();
                    CommandContext context = new CommandContext(this, this.config, this.discoveryService);
                    response = command.execute(msgWithData, context);
                }
            }
            finally {
                responseBody.close();
            }
        }
        catch (Throwable t) {
            log.errorCommandExecutionFailureFeed(requestClassName, t);
            String errorMessage = "Command failed [" + requestClassName + "]";
            GenericErrorResponse errorMsg = new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build();
            response = new BasicMessageWithExtraData((BasicMessage)errorMsg, null);
        }
        if (response != null) {
            try {
                this.sendSync((BasicMessageWithExtraData<? extends BasicMessage>)response);
            }
            catch (Exception e) {
                log.errorFailedToSendOverFeedComm(response.getClass().getName(), e);
            }
        }
    }

    public void onPong(Buffer buffer) {
        try {
            if (!buffer.equals((Object)this.createPingBuffer())) {
                log.debugf("Failed to verify WebSocket pong [%s]", buffer.toString());
            }
        }
        finally {
            buffer.close();
        }
    }

    private void configurationAuthentication(BasicMessage message) {
        if (!(message instanceof AuthMessage)) {
            return;
        }
        AuthMessage authMessage = (AuthMessage)message;
        Authentication auth = authMessage.getAuthentication();
        if (auth != null) {
            return;
        }
        auth = new Authentication();
        auth.setUsername(this.config.getStorageAdapter().getUsername());
        auth.setPassword(this.config.getStorageAdapter().getPassword());
        authMessage.setAuthentication(auth);
    }

    private void startReconnectJobThread() {
        ReconnectJobThread newReconnectJob = !this.destroyed ? new ReconnectJobThread() : null;
        ReconnectJobThread oldReconnectJob = this.reconnectJobThread.getAndSet(newReconnectJob);
        if (oldReconnectJob != null) {
            oldReconnectJob.interrupt();
        }
        if (newReconnectJob != null) {
            log.debugf("Starting WebSocket reconnect thread", new Object[0]);
            newReconnectJob.start();
        }
    }

    private void stopReconnectJobThread() {
        ReconnectJobThread reconnectJob = this.reconnectJobThread.getAndSet(null);
        if (reconnectJob != null) {
            log.debugf("Stopping WebSocket reconnect thread", new Object[0]);
            reconnectJob.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPinging() {
        ScheduledExecutorService scheduledExecutorService = this.pingExecutor;
        synchronized (scheduledExecutorService) {
            this.stopPinging();
            log.debugf("Starting WebSocket ping", new Object[0]);
            this.pingFuture = this.pingExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (FeedCommProcessor.this.isConnected()) {
                        try {
                            FeedCommProcessor.this.webSocket.sendPing(FeedCommProcessor.this.createPingBuffer());
                        }
                        catch (IOException ioe) {
                            log.debugf("Failed to send ping. Cause=%s", ioe.toString());
                            FeedCommProcessor.this.disconnect(4000, "Ping failed");
                        }
                        catch (IllegalStateException ise) {
                            log.debugf("Cannot ping. WebSocket is already closed. Cause=%s", ise.toString());
                        }
                        catch (Exception e) {
                            log.debugf("Cannot ping. Cause=%s", e.toString());
                        }
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPinging() {
        ScheduledExecutorService scheduledExecutorService = this.pingExecutor;
        synchronized (scheduledExecutorService) {
            if (this.pingFuture != null) {
                log.debugf("Stopping WebSocket ping", new Object[0]);
                this.pingFuture.cancel(true);
                this.pingFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyPingExecutor() {
        ScheduledExecutorService scheduledExecutorService = this.pingExecutor;
        synchronized (scheduledExecutorService) {
            if (!this.pingExecutor.isShutdown()) {
                try {
                    log.debugf("Shutting down WebSocket ping executor", new Object[0]);
                    this.pingExecutor.shutdown();
                    if (!this.pingExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        this.pingExecutor.shutdownNow();
                    }
                }
                catch (Throwable t) {
                    log.warnf("Cannot shut down WebSocket ping executor. Cause=%s", t.toString());
                }
            }
        }
    }

    private Buffer createPingBuffer() {
        return new Buffer().writeUtf8("hawkular-ping");
    }

    static {
        VALID_COMMANDS.put(AddDatasourceCommand.REQUEST_CLASS.getName(), AddDatasourceCommand.class);
        VALID_COMMANDS.put(AddJdbcDriverCommand.REQUEST_CLASS.getName(), AddJdbcDriverCommand.class);
        VALID_COMMANDS.put(DeployApplicationCommand.REQUEST_CLASS.getName(), DeployApplicationCommand.class);
        VALID_COMMANDS.put(DisableApplicationCommand.REQUEST_CLASS.getName(), DisableApplicationCommand.class);
        VALID_COMMANDS.put(EchoCommand.REQUEST_CLASS.getName(), EchoCommand.class);
        VALID_COMMANDS.put(EnableApplicationCommand.REQUEST_CLASS.getName(), EnableApplicationCommand.class);
        VALID_COMMANDS.put(ExecuteOperationCommand.REQUEST_CLASS.getName(), ExecuteOperationCommand.class);
        VALID_COMMANDS.put(ExportJdrCommand.REQUEST_CLASS.getName(), ExportJdrCommand.class);
        VALID_COMMANDS.put(GenericErrorResponseCommand.REQUEST_CLASS.getName(), GenericErrorResponseCommand.class);
        VALID_COMMANDS.put(RemoveDatasourceCommand.REQUEST_CLASS.getName(), RemoveDatasourceCommand.class);
        VALID_COMMANDS.put(RemoveJdbcDriverCommand.REQUEST_CLASS.getName(), RemoveJdbcDriverCommand.class);
        VALID_COMMANDS.put(RestartApplicationCommand.REQUEST_CLASS.getName(), RestartApplicationCommand.class);
        VALID_COMMANDS.put(StatisticsControlCommand.REQUEST_CLASS.getName(), StatisticsControlCommand.class);
        VALID_COMMANDS.put(UndeployApplicationCommand.REQUEST_CLASS.getName(), UndeployApplicationCommand.class);
        VALID_COMMANDS.put(UpdateDatasourceCommand.REQUEST_CLASS.getName(), UpdateDatasourceCommand.class);
        VALID_COMMANDS.put(UpdateCollectionIntervalsCommand.REQUEST_CLASS.getName(), UpdateCollectionIntervalsCommand.class);
    }

    private class ReconnectJobThread
    extends Thread {
        public ReconnectJobThread() {
            super("Hawkular WildFly Monitor Websocket Reconnect Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            int attemptCount = 0;
            long sleepInterval = 1000L;
            boolean keepTrying = true;
            while (keepTrying && !FeedCommProcessor.this.destroyed) {
                try {
                    ++attemptCount;
                    Thread.sleep(1000L);
                    if (!FeedCommProcessor.this.isConnected()) {
                        if (attemptCount % 60 == 0) {
                            log.errorCannotReconnectToWebSocket(new Exception("Attempt #" + attemptCount));
                        }
                        FeedCommProcessor.this.connect();
                        continue;
                    }
                    keepTrying = false;
                }
                catch (InterruptedException ie) {
                    keepTrying = false;
                }
                catch (Exception e) {
                    if (attemptCount % 60 != 0) continue;
                    log.errorCannotReconnectToWebSocket(e);
                }
            }
        }
    }
}

