/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.concurrent.atomic.AtomicReference;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceConfigurationBuilder;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class OperationSubsystemStart
implements OperationStepHandler {
    private static final Logger LOGGER = Logger.getLogger(OperationSubsystemStart.class);

    public void execute(OperationContext opContext, ModelNode model) throws OperationFailedException {
        AtomicReference<Thread> newThread = new AtomicReference<Thread>();
        try {
            ServiceName name = SubsystemExtension.SERVICE_NAME;
            ServiceRegistry serviceRegistry = opContext.getServiceRegistry(true);
            final MonitorService service = (MonitorService)serviceRegistry.getRequiredService(name).getValue();
            final boolean refresh = model.get("refresh").asBoolean(false);
            final boolean restart = refresh || model.get("restart").asBoolean(false);
            final long delay = model.get("delay").asLong(0L);
            PathAddress address = refresh ? WildflyCompatibilityUtils.getCurrentAddress(opContext, model) : null;
            ModelNode config = refresh ? Resource.Tools.readModel((Resource)opContext.readResourceFromRoot(address)) : null;
            final MonitorServiceConfiguration newConfig = refresh ? new MonitorServiceConfigurationBuilder(config, opContext).build() : null;
            newThread.set(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (delay > 0L) {
                            Thread.sleep(delay);
                        }
                        if (restart) {
                            LOGGER.warnf("Stopping Hawkular Monitor Service now, %s requested.", (Object)(refresh ? "refresh" : "restart"));
                            service.stopMonitorService();
                        }
                        if (service.getMonitorServiceStatus() == ServiceStatus.RUNNING) {
                            LOGGER.warn((Object)"Skipping Hawkular Monitor Service start, it is already started.");
                        } else {
                            LOGGER.warn((Object)"Starting Hawkular Monitor Service now.");
                            service.startMonitorService(newConfig);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)("Aborting start of the Hawkular Monitor service: " + e));
                        return;
                    }
                }
            }, "Hawkular WildFly Agent Operation Start Thread"));
            ((Thread)newThread.get()).setDaemon(true);
            ((Thread)newThread.get()).start();
        }
        catch (ServiceNotFoundException snfe) {
            throw new OperationFailedException("Cannot restart Hawkular Monitor service - it is disabled", (Throwable)snfe);
        }
        catch (Exception e) {
            if (newThread.get() != null) {
                ((Thread)newThread.get()).interrupt();
            }
            throw new OperationFailedException("Cannot restart Hawkular Monitor service", (Throwable)e);
        }
        opContext.stepCompleted();
    }
}

