/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.hawkular.inventory.paths.SegmentType;

public final class SyncConfiguration
implements Serializable {
    public static final SyncConfiguration DEFAULT = SyncConfiguration.builder().withAllTypes().withDeepSearch(false).build();
    private final EnumSet<SegmentType> syncedTypes;
    private final boolean deepSearch;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public SyncConfiguration(@JsonProperty(value="syncedTypes") EnumSet<SegmentType> syncedTypes, @JsonProperty(value="deepSearch", defaultValue="false") boolean deepSearch) {
        this.syncedTypes = syncedTypes;
        this.deepSearch = deepSearch;
    }

    public Set<SegmentType> getSyncedTypes() {
        return this.syncedTypes;
    }

    public boolean isDeepSearch() {
        return this.deepSearch;
    }

    public static final class Builder {
        private final EnumSet<SegmentType> syncedTypes = EnumSet.noneOf(SegmentType.class);
        private boolean deepSearch = false;

        private Builder() {
        }

        public Builder withType(SegmentType segmentType) {
            this.syncedTypes.add(segmentType);
            return this;
        }

        public Builder withTypes(SegmentType ... segmentTypes) {
            return this.withTypes(Arrays.asList(segmentTypes));
        }

        public Builder withTypes(Iterable<SegmentType> segmentTypes) {
            segmentTypes.forEach(this.syncedTypes::add);
            return this;
        }

        public Builder withAllTypes() {
            return this.withTypes(SegmentType.values());
        }

        public Builder withoutType(SegmentType segmentType) {
            this.syncedTypes.remove(segmentType);
            return this;
        }

        public Builder withoutTypes(SegmentType ... segmentTypes) {
            return this.withoutTypes(Arrays.asList(segmentTypes));
        }

        public Builder withoutTypes(Iterable<SegmentType> segmentTypes) {
            segmentTypes.forEach(this.syncedTypes::remove);
            return this;
        }

        public Builder withDeepSearch(boolean value) {
            this.deepSearch = value;
            return this;
        }

        public SyncConfiguration build() {
            return new SyncConfiguration(this.syncedTypes, this.deepSearch);
        }
    }
}

