/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;

class Associator<BE, E extends Entity<?, ?>>
extends Traversal<BE, E> {
    private final Relationships.WellKnown relationship;
    private final SegmentType sourceEntityType;

    protected Associator(TraversalContext<BE, E> context, Relationships.WellKnown relationship, SegmentType sourceEntityType) {
        super(context);
        this.relationship = relationship;
        this.sourceEntityType = sourceEntityType;
    }

    public Relationship associate(Path id) throws EntityNotFoundException, RelationAlreadyExistsException {
        this.checkPathLegal(id);
        return Associator.associate(this.context, this.sourceEntityType, this.relationship, id);
    }

    static <BE> Relationship associate(TraversalContext<BE, ?> context, SegmentType sourceEntityType, Relationships.WellKnown relationship, Path id) {
        return Associator.inTx(context, tx -> {
            Object target = Util.find(tx, context.sourcePath, id);
            Query sourceQuery = context.sourcePath.extend().filter().with(With.type(sourceEntityType)).get();
            Object source = tx.querySingle(sourceQuery);
            EntityAndPendingNotifications rel = Util.createAssociation(tx, source, relationship.name(), target, null);
            tx.getPreCommit().addNotifications(rel);
            return rel.getEntity();
        });
    }

    public Relationship disassociate(Path id) throws EntityNotFoundException {
        this.checkPathLegal(id);
        return Associator.disassociate(this.context, this.sourceEntityType, this.relationship, id);
    }

    static <BE> Relationship disassociate(TraversalContext<BE, ?> context, SegmentType sourceEntityType, Relationships.WellKnown relationship, Path id) {
        return Associator.inTx(context, tx -> {
            Object target = Util.find(tx, context.sourcePath, id);
            Query sourceQuery = context.sourcePath.extend().filter().with(With.type(sourceEntityType)).get();
            EntityAndPendingNotifications rel = Util.deleteAssociation(tx, sourceQuery, sourceEntityType, relationship.name(), target);
            tx.getPreCommit().addNotifications(rel);
            return rel.getEntity();
        });
    }

    public Relationship associationWith(Path path) throws RelationNotFoundException {
        return Associator.associationWith(this.context, this.sourceEntityType, this.relationship, path);
    }

    static <BE> Relationship associationWith(TraversalContext<BE, ?> context, SegmentType sourceEntityType, Relationships.WellKnown relationship, Path path) throws RelationNotFoundException {
        return Associator.inTx(context, tx -> {
            Query sourceQuery = context.sourcePath.extend().filter().with(With.type(sourceEntityType)).get();
            Query targetQuery = Util.queryTo(context.sourcePath, path);
            SegmentType targetType = path.getSegment().getElementType();
            return Util.getAssociation(tx, sourceQuery, sourceEntityType, targetQuery, targetType, relationship.name());
        });
    }

    protected void checkPathLegal(Path targetPath) {
        if (!this.context.entityClass.getSimpleName().equals(targetPath.getSegment().getElementType().getSimpleName())) {
            throw new IllegalArgumentException("Current position in the inventory traversal expects entities of type " + this.context.entityClass.getSimpleName() + " which is incompatible with the provided path: " + targetPath);
        }
    }

    protected Class<? extends Entity<?, ?>> getSourceType() {
        return this.context.previous.entityClass;
    }
}

