/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HTTPConnectorDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.Messaging14SubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class Messaging20SubsystemParser
extends Messaging14SubsystemParser {
    private static final Messaging20SubsystemParser INSTANCE = new Messaging20SubsystemParser();

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    protected Messaging20SubsystemParser() {
    }

    @Override
    void processConnectors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            String serverId = null;
            int count = reader.getAttributeCount();
            block12: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block12;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block12;
                    }
                    case SERVER_ID: {
                        serverId = attrValue;
                        continue block12;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode connectorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            boolean generic = false;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    operation.get("address").set(connectorAddress.add("connector", name));
                    if (socketBinding != null) {
                        operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    generic = true;
                    break;
                }
                case NETTY_CONNECTOR: {
                    operation.get("address").set(connectorAddress.add("remote-connector", name));
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    break;
                }
                case IN_VM_CONNECTOR: {
                    operation.get("address").set(connectorAddress.add("in-vm-connector", name));
                    if (serverId == null) break;
                    InVMTransportDefinition.SERVER_ID.parseAndSetParameter(serverId, operation, (XMLStreamReader)reader);
                    break;
                }
                case HTTP_CONNECTOR: {
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get("address").set(connectorAddress.add("http-connector", name));
                    HTTPConnectorDefinition.SOCKET_BINDING.parseAndSetParameter(socketBinding, operation, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            updates.add(operation);
            this.parseTransportConfiguration(reader, operation, generic, updates);
        }
    }

    @Override
    void processAcceptors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            String serverId = null;
            String httpListener = null;
            int count = reader.getAttributeCount();
            block13: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block13;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block13;
                    }
                    case SERVER_ID: {
                        serverId = attrValue;
                        continue block13;
                    }
                    case HTTP_LISTENER: {
                        httpListener = attrValue;
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode acceptorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            Element element = Element.forName(reader.getLocalName());
            boolean generic = false;
            switch (element) {
                case ACCEPTOR: {
                    operation.get("address").set(acceptorAddress.add("acceptor", name));
                    if (socketBinding != null) {
                        operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    generic = true;
                    break;
                }
                case NETTY_ACCEPTOR: {
                    operation.get("address").set(acceptorAddress.add("remote-acceptor", name));
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    break;
                }
                case IN_VM_ACCEPTOR: {
                    operation.get("address").set(acceptorAddress.add("in-vm-acceptor", name));
                    if (serverId == null) break;
                    InVMTransportDefinition.SERVER_ID.parseAndSetParameter(serverId, operation, (XMLStreamReader)reader);
                    break;
                }
                case HTTP_ACCEPTOR: {
                    if (httpListener == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.HTTP_LISTENER));
                    }
                    operation.get("address").set(acceptorAddress.add("http-acceptor", name));
                    HTTPAcceptorDefinition.HTTP_LISTENER.parseAndSetParameter(httpListener, operation, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            updates.add(operation);
            this.parseTransportConfiguration(reader, operation, generic, updates);
        }
    }

    @Override
    protected void handleUnknownBridgeAttribute(XMLExtendedStreamReader reader, Element element, ModelNode bridgeAdd) throws XMLStreamException {
        switch (element) {
            case RECONNECT_ATTEMPTS_ON_SAME_NODE: {
                Messaging20SubsystemParser.handleElementText(reader, element, bridgeAdd);
                break;
            }
            case INITIAL_CONNECT_ATTEMPTS: {
                Messaging20SubsystemParser.handleElementText(reader, element, "bridge", bridgeAdd);
                break;
            }
            default: {
                super.handleUnknownBridgeAttribute(reader, element, bridgeAdd);
            }
        }
    }

    @Override
    protected void handleUnknownAddressSetting(XMLExtendedStreamReader reader, Element element, ModelNode addressSettingsAdd) throws XMLStreamException {
        switch (element) {
            case EXPIRY_DELAY: {
                Messaging20SubsystemParser.handleElementText(reader, element, addressSettingsAdd);
                break;
            }
            default: {
                super.handleUnknownAddressSetting(reader, element, addressSettingsAdd);
            }
        }
    }

    @Override
    protected void handleUnknownClusterConnectionAttribute(XMLExtendedStreamReader reader, Element element, ModelNode clusterConnectionAdd) throws XMLStreamException {
        switch (element) {
            case INITIAL_CONNECT_ATTEMPTS: {
                Messaging20SubsystemParser.handleElementText(reader, element, "cluster", clusterConnectionAdd);
                break;
            }
            default: {
                super.handleUnknownClusterConnectionAttribute(reader, element, clusterConnectionAdd);
            }
        }
    }
}

