/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.lang.reflect.Array;
import java.util.List;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;

public class ClusterConfigurationUtil {
    public static TransportConfiguration getTransportConfiguration(ClusterConnectionConfiguration config, Configuration configuration) {
        if (config.getName() == null) {
            ActiveMQServerLogger.LOGGER.clusterConnectionNotUnique();
            return null;
        }
        if (config.getAddress() == null) {
            ActiveMQServerLogger.LOGGER.clusterConnectionNoForwardAddress();
            return null;
        }
        TransportConfiguration connector = configuration.getConnectorConfigurations().get(config.getConnectorName());
        if (connector == null) {
            ActiveMQServerLogger.LOGGER.clusterConnectionNoConnector(config.getConnectorName());
            return null;
        }
        return connector;
    }

    public static DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(ClusterConnectionConfiguration config, Configuration configuration) {
        DiscoveryGroupConfiguration dg = configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
        if (dg == null) {
            ActiveMQServerLogger.LOGGER.clusterConnectionNoDiscoveryGroup(config.getDiscoveryGroupName());
            return null;
        }
        return dg;
    }

    public static TransportConfiguration[] getTransportConfigurations(ClusterConnectionConfiguration config, Configuration configuration) {
        return config.getStaticConnectors() != null ? ClusterConfigurationUtil.connectorNameListToArray(config.getStaticConnectors(), configuration) : null;
    }

    public static TransportConfiguration[] connectorNameListToArray(List<String> connectorNames, Configuration configuration) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = configuration.getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                ActiveMQServerLogger.LOGGER.bridgeNoConnector(connectorName);
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }
}

