/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.TransientQueueManager;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;

public class TransientQueueManagerImpl
implements TransientQueueManager {
    private final SimpleString queueName;
    private final ActiveMQServer server;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("deleting temporary queue " + TransientQueueManagerImpl.this.queueName);
                }
                try {
                    TransientQueueManagerImpl.this.server.destroyQueue(TransientQueueManagerImpl.this.queueName, null, false);
                }
                catch (ActiveMQException e) {
                    ActiveMQServerLogger.LOGGER.warn("Error on deleting queue " + TransientQueueManagerImpl.this.queueName + ", " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingTempQueue(e, TransientQueueManagerImpl.this.queueName);
            }
        }
    };
    private final ReferenceCounterUtil referenceCounterUtil = new ReferenceCounterUtil(this.runnable);

    public TransientQueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        this.server = server;
        this.queueName = queueName;
    }

    public int increment() {
        return this.referenceCounterUtil.increment();
    }

    public int decrement() {
        return this.referenceCounterUtil.decrement();
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

