/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class MixedKeyedJDBCStoreBuilder
extends JDBCStoreBuilder<JdbcMixedStoreConfiguration, JdbcMixedStoreConfigurationBuilder> {
    private final InjectedValue<TableManipulationConfiguration> binaryTable = new InjectedValue();
    private final InjectedValue<TableManipulationConfiguration> stringTable = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile JdbcMixedStoreConfigurationBuilder builder;

    MixedKeyedJDBCStoreBuilder(String containerName, String cacheName) {
        super(JdbcMixedStoreConfigurationBuilder.class, containerName, cacheName);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.BINARY_TABLE.getServiceName(this.containerName, this.cacheName), TableManipulationConfiguration.class, this.binaryTable).addDependency(CacheComponent.STRING_TABLE.getServiceName(this.containerName, this.cacheName), TableManipulationConfiguration.class, this.stringTable);
    }

    @Override
    public PersistenceConfiguration getValue() {
        this.builder.binaryTable().read((TableManipulationConfiguration)this.binaryTable.getValue());
        this.builder.stringTable().read((TableManipulationConfiguration)this.stringTable.getValue());
        return super.getValue();
    }

    @Override
    JdbcMixedStoreConfigurationBuilder createStore(OperationContext context, ModelNode model) throws OperationFailedException {
        this.builder = (JdbcMixedStoreConfigurationBuilder)super.createStore(context, model);
        return this.builder;
    }
}

