/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public abstract class ThreadsWriteAttributeOperationHandler
extends AbstractWriteAttributeHandler<Boolean> {
    protected final AttributeDefinition[] attributes;
    protected final Map<String, AttributeDefinition> runtimeAttributes = new HashMap<String, AttributeDefinition>();

    public ThreadsWriteAttributeOperationHandler(AttributeDefinition[] attributes, AttributeDefinition[] runtimeAttributes) {
        super(attributes);
        this.attributes = attributes;
        for (AttributeDefinition attr : runtimeAttributes) {
            this.runtimeAttributes.put(attr.getName(), attr);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
        AttributeDefinition attr = this.runtimeAttributes.get(attributeName);
        if (attr == null) {
            return true;
        }
        ServiceController<?> service = this.getService(context, operation);
        if (service == null) {
            return false;
        }
        if (service.getState() != ServiceController.State.UP) {
            return true;
        }
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.applyOperation(context, model, attributeName, service, false);
        handbackHolder.setHandback((Object)Boolean.TRUE);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
        ServiceController<?> service;
        if (handback != null && handback.booleanValue() && this.runtimeAttributes.containsKey(attributeName) && (service = this.getService(context, operation)) != null && service.getState() == ServiceController.State.UP) {
            ModelNode revertModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
            revertModel.get(attributeName).set(valueToRestore);
            this.applyOperation(context, revertModel, attributeName, service, true);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attribute : this.attributes) {
            registry.registerReadWriteAttribute(attribute, null, (OperationStepHandler)this);
        }
    }

    protected abstract ServiceController<?> getService(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected abstract void applyOperation(OperationContext var1, ModelNode var2, String var3, ServiceController<?> var4, boolean var5) throws OperationFailedException;

    static TimeSpec getTimeSpec(OperationContext context, ModelNode model, TimeUnit defaultUnit) throws OperationFailedException {
        TimeUnit unit;
        ModelNode value = PoolAttributeDefinitions.KEEPALIVE_TIME.resolveModelAttribute(context, model);
        if (!value.hasDefined("time")) {
            throw ThreadsLogger.ROOT_LOGGER.missingTimeSpecTime("time", "keepalive-time");
        }
        if (!value.hasDefined("unit")) {
            unit = defaultUnit;
        } else {
            try {
                unit = Enum.valueOf(TimeUnit.class, value.get("unit").asString());
            }
            catch (IllegalArgumentException e) {
                throw ThreadsLogger.ROOT_LOGGER.failedToParseUnit("unit", Arrays.asList(TimeUnit.values()));
            }
        }
        return new TimeSpec(unit, value.get("time").asLong());
    }
}

