/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.securityEvent.HttpsTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityToken.HttpsSecurityToken;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.wss4j.stax.utils.WSSUtils;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.impl.InboundSecurityContextImpl;
import org.apache.xml.security.stax.securityEvent.AlgorithmSuiteSecurityEvent;
import org.apache.xml.security.stax.securityEvent.ContentEncryptedElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.EncryptedElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SignedElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.InboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundWSSecurityContextImpl
extends InboundSecurityContextImpl
implements WSInboundSecurityContext {
    private static final Logger LOG = LoggerFactory.getLogger(InboundWSSecurityContextImpl.class);
    private final Deque<SecurityEvent> securityEventQueue = new ArrayDeque<SecurityEvent>();
    private boolean operationSecurityEventOccured = false;
    private boolean messageEncryptionTokenOccured = false;
    private boolean allowRSA15KeyTransportAlgorithm = false;
    private boolean disableBSPEnforcement;
    private List<BSPRule> ignoredBSPRules = Collections.emptyList();

    public synchronized void registerSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
        if (WSSecurityEventConstants.AlgorithmSuite.equals((Object)securityEvent.getSecurityEventType())) {
            this.forwardSecurityEvent((SecurityEvent)securityEvent);
            return;
        }
        if (this.operationSecurityEventOccured) {
            TokenSecurityEvent tokenSecurityEvent;
            if (!this.messageEncryptionTokenOccured && securityEvent instanceof TokenSecurityEvent && ((InboundSecurityToken)(tokenSecurityEvent = (TokenSecurityEvent)securityEvent).getSecurityToken()).getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_Encryption)) {
                InboundSecurityToken securityToken = (InboundSecurityToken)WSSUtils.getRootToken(tokenSecurityEvent.getSecurityToken());
                TokenSecurityEvent<? extends InboundSecurityToken> newTokenSecurityEvent = WSSUtils.createTokenSecurityEvent(securityToken, tokenSecurityEvent.getCorrelationID());
                this.setTokenUsage(newTokenSecurityEvent, WSSecurityTokenConstants.TokenUsage_MainEncryption);
                securityEvent = newTokenSecurityEvent;
                this.messageEncryptionTokenOccured = true;
            }
            this.forwardSecurityEvent((SecurityEvent)securityEvent);
            return;
        }
        if (WSSecurityEventConstants.Operation.equals((Object)securityEvent.getSecurityEventType())) {
            this.operationSecurityEventOccured = true;
            this.identifySecurityTokenDepenedenciesAndUsage(this.securityEventQueue);
            Iterator<SecurityEvent> securityEventIterator = this.securityEventQueue.descendingIterator();
            while (securityEventIterator.hasNext()) {
                SecurityEvent prevSecurityEvent = securityEventIterator.next();
                this.forwardSecurityEvent(prevSecurityEvent);
            }
            this.forwardSecurityEvent((SecurityEvent)securityEvent);
            this.securityEventQueue.clear();
            return;
        }
        this.securityEventQueue.push((SecurityEvent)securityEvent);
    }

    protected void forwardSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
        if (!this.allowRSA15KeyTransportAlgorithm && SecurityEventConstants.AlgorithmSuite.equals((Object)securityEvent.getSecurityEventType())) {
            AlgorithmSuiteSecurityEvent algorithmSuiteSecurityEvent = (AlgorithmSuiteSecurityEvent)securityEvent;
            Boolean allowRSA15 = (Boolean)this.get("secureProcessing.AllowRSA15KeyTransportAlgorithm");
            if ((allowRSA15 == null || !allowRSA15.booleanValue()) && "http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(algorithmSuiteSecurityEvent.getAlgorithmURI())) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "secureProcessing.AllowRSA15KeyTransportAlgorithm");
            }
        }
        try {
            super.forwardSecurityEvent(securityEvent);
        }
        catch (WSSecurityException e) {
            throw e;
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)((Object)e));
        }
    }

    private void identifySecurityTokenDepenedenciesAndUsage(Deque<SecurityEvent> securityEventDeque) throws XMLSecurityException {
        TokenSecurityEvent<? extends InboundSecurityToken> supportingToken;
        Iterator<TokenSecurityEvent<? extends InboundSecurityToken>> iterator;
        InboundSecurityToken messageSignatureToken;
        TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent;
        TokenSecurityEvent tokenSecurityEvent2;
        List<TokenSecurityEvent<? extends InboundSecurityToken>> messageSignatureTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> messageEncryptionTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> supportingTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> signedSupportingTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> endorsingSupportingTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> signedEndorsingSupportingTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> signedEncryptedSupportingTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> encryptedSupportingTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> endorsingEncryptedSupportingTokens = Collections.emptyList();
        List<TokenSecurityEvent<? extends InboundSecurityToken>> signedEndorsingEncryptedSupportingTokens = Collections.emptyList();
        HttpsTokenSecurityEvent httpsTokenSecurityEvent = null;
        ArrayList<TokenSecurityEvent<? extends InboundSecurityToken>> tokenSecurityEvents = new ArrayList<TokenSecurityEvent<? extends InboundSecurityToken>>();
        for (SecurityEvent securityEvent : securityEventDeque) {
            if (!(securityEvent instanceof TokenSecurityEvent)) continue;
            tokenSecurityEvent2 = (TokenSecurityEvent)securityEvent;
            if (WSSecurityEventConstants.HttpsToken.equals((Object)securityEvent.getSecurityEventType())) {
                HttpsTokenSecurityEvent actHttpsTokenSecurityEvent = (HttpsTokenSecurityEvent)tokenSecurityEvent2;
                ((HttpsSecurityToken)actHttpsTokenSecurityEvent.getSecurityToken()).getTokenUsages().clear();
                ((HttpsSecurityToken)actHttpsTokenSecurityEvent.getSecurityToken()).addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
                messageSignatureTokens = this.addTokenSecurityEvent(actHttpsTokenSecurityEvent, messageSignatureTokens);
                HttpsTokenSecurityEvent clonedHttpsTokenSecurityEvent = new HttpsTokenSecurityEvent();
                clonedHttpsTokenSecurityEvent.setAuthenticationType(actHttpsTokenSecurityEvent.getAuthenticationType());
                clonedHttpsTokenSecurityEvent.setIssuerName(actHttpsTokenSecurityEvent.getIssuerName());
                clonedHttpsTokenSecurityEvent.setSecurityToken(actHttpsTokenSecurityEvent.getSecurityToken());
                ((HttpsSecurityToken)clonedHttpsTokenSecurityEvent.getSecurityToken()).addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainEncryption);
                messageEncryptionTokens = this.addTokenSecurityEvent(actHttpsTokenSecurityEvent, messageEncryptionTokens);
                httpsTokenSecurityEvent = clonedHttpsTokenSecurityEvent;
                continue;
            }
            tokenSecurityEvents.add(tokenSecurityEvent2);
        }
        for (int i = 0; i < tokenSecurityEvents.size(); ++i) {
            tokenSecurityEvent2 = (TokenSecurityEvent)tokenSecurityEvents.get(i);
            InboundSecurityToken securityToken = (InboundSecurityToken)WSSUtils.getRootToken(tokenSecurityEvent2.getSecurityToken());
            if (!this.containsSecurityToken(supportingTokens, (SecurityToken)securityToken)) {
                TokenSecurityEvent<? extends InboundSecurityToken> newTokenSecurityEvent = WSSUtils.createTokenSecurityEvent(securityToken, tokenSecurityEvent2.getCorrelationID());
                supportingTokens = this.addTokenSecurityEvent(newTokenSecurityEvent, supportingTokens);
                securityEventDeque.offer((SecurityEvent)newTokenSecurityEvent);
            }
            securityEventDeque.remove(tokenSecurityEvent2);
        }
        Iterator supportingTokensIterator = supportingTokens.iterator();
        while (supportingTokensIterator.hasNext()) {
            tokenSecurityEvent2 = (TokenSecurityEvent)supportingTokensIterator.next();
            List<InboundSecurityToken> signingSecurityTokens = this.isSignedToken((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, securityEventDeque, httpsTokenSecurityEvent);
            ArrayList<QName> signatureElementPath = new ArrayList<QName>(4);
            signatureElementPath.addAll(WSSConstants.WSSE_SECURITY_HEADER_PATH);
            signatureElementPath.add(WSSConstants.TAG_dsig_Signature);
            boolean signsSignature = this.signsElement((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, signatureElementPath, securityEventDeque);
            boolean encryptsSignature = this.encryptsElement((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, signatureElementPath, securityEventDeque);
            ArrayList<QName> signatureConfirmationElementPath = new ArrayList<QName>(4);
            signatureConfirmationElementPath.addAll(WSSConstants.WSSE_SECURITY_HEADER_PATH);
            signatureConfirmationElementPath.add(WSSConstants.TAG_wsse11_SignatureConfirmation);
            boolean signsSignatureConfirmation = this.signsElement((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, signatureConfirmationElementPath, securityEventDeque);
            boolean encryptsSignatureConfirmation = this.encryptsElement((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, signatureConfirmationElementPath, securityEventDeque);
            ArrayList<QName> timestampElementPath = new ArrayList<QName>(4);
            timestampElementPath.addAll(WSSConstants.WSSE_SECURITY_HEADER_PATH);
            timestampElementPath.add(WSSConstants.TAG_wsu_Timestamp);
            boolean signsTimestamp = this.signsElement((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, timestampElementPath, securityEventDeque);
            ArrayList<QName> usernameTokenElementPath = new ArrayList<QName>(4);
            usernameTokenElementPath.addAll(WSSConstants.WSSE_SECURITY_HEADER_PATH);
            usernameTokenElementPath.add(WSSConstants.TAG_wsse_UsernameToken);
            boolean encryptsUsernameToken = this.encryptsElement((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, usernameTokenElementPath, securityEventDeque);
            boolean transportSecurityActive = Boolean.TRUE == this.get("transportSecurityActive");
            List<InboundSecurityToken> encryptingSecurityTokens = this.isEncryptedToken((TokenSecurityEvent<? extends SecurityToken>)tokenSecurityEvent2, securityEventDeque, httpsTokenSecurityEvent);
            boolean signatureUsage = ((InboundSecurityToken)tokenSecurityEvent2.getSecurityToken()).getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_Signature);
            boolean encryptionUsage = ((InboundSecurityToken)tokenSecurityEvent2.getSecurityToken()).getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_Encryption);
            if (!transportSecurityActive && signsSignatureConfirmation && signsTimestamp && !signsSignature) {
                supportingTokensIterator.remove();
                messageSignatureTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, messageSignatureTokens);
                if (!encryptionUsage) continue;
                messageEncryptionTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, messageEncryptionTokens);
                continue;
            }
            if (!transportSecurityActive && signsSignatureConfirmation && !signsSignature) {
                supportingTokensIterator.remove();
                messageSignatureTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, messageSignatureTokens);
                if (!encryptionUsage) continue;
                messageEncryptionTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, messageEncryptionTokens);
                continue;
            }
            if (!transportSecurityActive && signsTimestamp && !signsSignature) {
                supportingTokensIterator.remove();
                messageSignatureTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, messageSignatureTokens);
                if (!encryptionUsage) continue;
                messageEncryptionTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, messageEncryptionTokens);
                continue;
            }
            if (!transportSecurityActive && (encryptsSignature || encryptsSignatureConfirmation || encryptsUsernameToken)) {
                supportingTokensIterator.remove();
                messageEncryptionTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, messageEncryptionTokens);
                continue;
            }
            if (signsSignature && signingSecurityTokens.size() > 0 && encryptingSecurityTokens.size() > 0) {
                supportingTokensIterator.remove();
                signedEndorsingEncryptedSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, signedEndorsingEncryptedSupportingTokens);
                continue;
            }
            if (transportSecurityActive && signsTimestamp && signingSecurityTokens.size() > 0 && encryptingSecurityTokens.size() > 0) {
                supportingTokensIterator.remove();
                signedEndorsingEncryptedSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, signedEndorsingEncryptedSupportingTokens);
                continue;
            }
            if (signsSignature && signingSecurityTokens.size() == 0 && encryptingSecurityTokens.size() > 0) {
                supportingTokensIterator.remove();
                endorsingEncryptedSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, endorsingEncryptedSupportingTokens);
                continue;
            }
            if (signsSignature && signingSecurityTokens.size() > 0) {
                supportingTokensIterator.remove();
                signedEndorsingSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, signedEndorsingSupportingTokens);
                continue;
            }
            if (signatureUsage && signingSecurityTokens.size() > 0) {
                supportingTokensIterator.remove();
                signedEndorsingSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, signedEndorsingSupportingTokens);
                continue;
            }
            if (signsSignature) {
                supportingTokensIterator.remove();
                endorsingSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, endorsingSupportingTokens);
                continue;
            }
            if (signingSecurityTokens.size() > 0 && encryptingSecurityTokens.size() > 0) {
                supportingTokensIterator.remove();
                signedEncryptedSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, signedEncryptedSupportingTokens);
                continue;
            }
            if (signingSecurityTokens.size() > 0) {
                supportingTokensIterator.remove();
                signedSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, signedSupportingTokens);
                continue;
            }
            if (encryptingSecurityTokens.size() <= 0) continue;
            supportingTokensIterator.remove();
            encryptedSupportingTokens = this.addTokenSecurityEvent((TokenSecurityEvent<? extends InboundSecurityToken>)tokenSecurityEvent2, encryptedSupportingTokens);
        }
        if (messageSignatureTokens.isEmpty() && (tokenSecurityEvent = this.getTokenSecurityEvent(messageSignatureToken = this.getSupportingTokenSigningToken(signedSupportingTokens, signedEndorsingSupportingTokens, signedEncryptedSupportingTokens, signedEndorsingEncryptedSupportingTokens, securityEventDeque), tokenSecurityEvents)) != null) {
            this.removeTokenSecurityEvent(tokenSecurityEvent, supportingTokens);
            this.removeTokenSecurityEvent(tokenSecurityEvent, signedSupportingTokens);
            this.removeTokenSecurityEvent(tokenSecurityEvent, endorsingSupportingTokens);
            this.removeTokenSecurityEvent(tokenSecurityEvent, signedEndorsingSupportingTokens);
            this.removeTokenSecurityEvent(tokenSecurityEvent, signedEncryptedSupportingTokens);
            this.removeTokenSecurityEvent(tokenSecurityEvent, encryptedSupportingTokens);
            this.removeTokenSecurityEvent(tokenSecurityEvent, endorsingEncryptedSupportingTokens);
            this.removeTokenSecurityEvent(tokenSecurityEvent, signedEndorsingEncryptedSupportingTokens);
            messageSignatureTokens = this.addTokenSecurityEvent(tokenSecurityEvent, messageSignatureTokens);
        }
        if (messageSignatureTokens.isEmpty()) {
            iterator = supportingTokens.iterator();
            while (iterator.hasNext()) {
                supportingToken = iterator.next();
                if (!((InboundSecurityToken)supportingToken.getSecurityToken()).getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_Signature)) continue;
                iterator.remove();
                messageSignatureTokens = this.addTokenSecurityEvent(supportingToken, messageSignatureTokens);
                break;
            }
        }
        if (messageEncryptionTokens.isEmpty()) {
            iterator = supportingTokens.iterator();
            while (iterator.hasNext()) {
                supportingToken = iterator.next();
                if (!((InboundSecurityToken)supportingToken.getSecurityToken()).getTokenUsages().contains(WSSecurityTokenConstants.TokenUsage_Encryption)) continue;
                iterator.remove();
                messageEncryptionTokens = this.addTokenSecurityEvent(supportingToken, messageEncryptionTokens);
                break;
            }
        }
        if (!messageEncryptionTokens.isEmpty()) {
            this.messageEncryptionTokenOccured = true;
        }
        this.setTokenUsage(messageSignatureTokens, WSSecurityTokenConstants.TokenUsage_MainSignature);
        this.setTokenUsage(messageEncryptionTokens, WSSecurityTokenConstants.TokenUsage_MainEncryption);
        this.setTokenUsage(supportingTokens, WSSecurityTokenConstants.TokenUsage_SupportingTokens);
        this.setTokenUsage(signedSupportingTokens, WSSecurityTokenConstants.TokenUsage_SignedSupportingTokens);
        this.setTokenUsage(endorsingSupportingTokens, WSSecurityTokenConstants.TokenUsage_EndorsingSupportingTokens);
        this.setTokenUsage(signedEndorsingSupportingTokens, WSSecurityTokenConstants.TokenUsage_SignedEndorsingSupportingTokens);
        this.setTokenUsage(signedEncryptedSupportingTokens, WSSecurityTokenConstants.TokenUsage_SignedEncryptedSupportingTokens);
        this.setTokenUsage(encryptedSupportingTokens, WSSecurityTokenConstants.TokenUsage_EncryptedSupportingTokens);
        this.setTokenUsage(endorsingEncryptedSupportingTokens, WSSecurityTokenConstants.TokenUsage_EndorsingEncryptedSupportingTokens);
        this.setTokenUsage(signedEndorsingEncryptedSupportingTokens, WSSecurityTokenConstants.TokenUsage_SignedEndorsingEncryptedSupportingTokens);
    }

    private void removeTokenSecurityEvent(TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent, List<TokenSecurityEvent<? extends InboundSecurityToken>> tokenSecurityEventList) {
        for (int i = 0; i < tokenSecurityEventList.size(); ++i) {
            TokenSecurityEvent<? extends InboundSecurityToken> securityEvent = tokenSecurityEventList.get(i);
            if (!((InboundSecurityToken)securityEvent.getSecurityToken()).getId().equals(((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getId())) continue;
            tokenSecurityEventList.remove(securityEvent);
            return;
        }
    }

    private List<TokenSecurityEvent<? extends InboundSecurityToken>> addTokenSecurityEvent(TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent, List<TokenSecurityEvent<? extends InboundSecurityToken>> tokenSecurityEventList) {
        if (tokenSecurityEventList == Collections.emptyList()) {
            tokenSecurityEventList = new ArrayList<TokenSecurityEvent<? extends InboundSecurityToken>>();
        }
        tokenSecurityEventList.add(tokenSecurityEvent);
        return tokenSecurityEventList;
    }

    private boolean containsSecurityToken(List<TokenSecurityEvent<? extends InboundSecurityToken>> supportingTokens, SecurityToken securityToken) {
        if (securityToken != null) {
            for (int i = 0; i < supportingTokens.size(); ++i) {
                TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent = supportingTokens.get(i);
                if (!tokenSecurityEvent.getSecurityToken().getId().equals(securityToken.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private TokenSecurityEvent<? extends InboundSecurityToken> getTokenSecurityEvent(InboundSecurityToken securityToken, List<TokenSecurityEvent<? extends InboundSecurityToken>> tokenSecurityEvents) throws XMLSecurityException {
        if (securityToken != null) {
            for (int i = 0; i < tokenSecurityEvents.size(); ++i) {
                TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent = tokenSecurityEvents.get(i);
                if (!((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getId().equals(securityToken.getId())) continue;
                return tokenSecurityEvent;
            }
        }
        return null;
    }

    private InboundSecurityToken getSupportingTokenSigningToken(List<TokenSecurityEvent<? extends InboundSecurityToken>> signedSupportingTokens, List<TokenSecurityEvent<? extends InboundSecurityToken>> signedEndorsingSupportingTokens, List<TokenSecurityEvent<? extends InboundSecurityToken>> signedEncryptedSupportingTokens, List<TokenSecurityEvent<? extends InboundSecurityToken>> signedEndorsingEncryptedSupportingTokens, Deque<SecurityEvent> securityEventDeque) throws XMLSecurityException {
        List<InboundSecurityToken> signingSecurityTokens;
        TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent;
        int i;
        for (i = 0; i < signedSupportingTokens.size(); ++i) {
            tokenSecurityEvent = signedSupportingTokens.get(i);
            signingSecurityTokens = this.getSigningToken(tokenSecurityEvent, securityEventDeque);
            if (signingSecurityTokens.size() != 1) continue;
            return signingSecurityTokens.get(0);
        }
        for (i = 0; i < signedEndorsingSupportingTokens.size(); ++i) {
            tokenSecurityEvent = signedEndorsingSupportingTokens.get(i);
            signingSecurityTokens = this.getSigningToken(tokenSecurityEvent, securityEventDeque);
            if (signingSecurityTokens.size() != 1) continue;
            return signingSecurityTokens.get(0);
        }
        for (i = 0; i < signedEncryptedSupportingTokens.size(); ++i) {
            tokenSecurityEvent = signedEncryptedSupportingTokens.get(i);
            signingSecurityTokens = this.getSigningToken(tokenSecurityEvent, securityEventDeque);
            if (signingSecurityTokens.size() != 1) continue;
            return signingSecurityTokens.get(0);
        }
        for (i = 0; i < signedEndorsingEncryptedSupportingTokens.size(); ++i) {
            tokenSecurityEvent = signedEndorsingEncryptedSupportingTokens.get(i);
            signingSecurityTokens = this.getSigningToken(tokenSecurityEvent, securityEventDeque);
            if (signingSecurityTokens.size() != 1) continue;
            return signingSecurityTokens.get(0);
        }
        return null;
    }

    private List<InboundSecurityToken> getSigningToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, Deque<SecurityEvent> securityEventDeque) throws XMLSecurityException {
        ArrayList<InboundSecurityToken> signingSecurityTokens = new ArrayList<InboundSecurityToken>();
        for (SecurityEvent securityEvent : securityEventDeque) {
            SignedElementSecurityEvent signedElementSecurityEvent;
            if (!WSSecurityEventConstants.SignedElement.equals((Object)securityEvent.getSecurityEventType()) || !(signedElementSecurityEvent = (SignedElementSecurityEvent)securityEvent).isSigned() || !WSSUtils.pathMatches(signedElementSecurityEvent.getElementPath(), ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getElementPath(), true, false)) continue;
            signingSecurityTokens.add((InboundSecurityToken)signedElementSecurityEvent.getSecurityToken());
        }
        return signingSecurityTokens;
    }

    private void setTokenUsage(List<TokenSecurityEvent<? extends InboundSecurityToken>> tokenSecurityEvents, SecurityTokenConstants.TokenUsage tokenUsage) throws XMLSecurityException {
        for (int i = 0; i < tokenSecurityEvents.size(); ++i) {
            TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent = tokenSecurityEvents.get(i);
            this.setTokenUsage(tokenSecurityEvent, tokenUsage);
        }
    }

    private void setTokenUsage(TokenSecurityEvent<? extends InboundSecurityToken> tokenSecurityEvent, SecurityTokenConstants.TokenUsage tokenUsage) throws XMLSecurityException {
        ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getTokenUsages().remove(WSSecurityTokenConstants.TokenUsage_SupportingTokens);
        ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getTokenUsages().remove(WSSecurityTokenConstants.TokenUsage_Signature);
        ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getTokenUsages().remove(WSSecurityTokenConstants.TokenUsage_Encryption);
        ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).addTokenUsage(tokenUsage);
    }

    private List<InboundSecurityToken> isSignedToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, Deque<SecurityEvent> securityEventDeque, HttpsTokenSecurityEvent httpsTokenSecurityEvent) throws XMLSecurityException {
        ArrayList<InboundSecurityToken> securityTokenList = new ArrayList<InboundSecurityToken>();
        if (httpsTokenSecurityEvent != null) {
            securityTokenList.add((InboundSecurityToken)httpsTokenSecurityEvent.getSecurityToken());
            return securityTokenList;
        }
        for (SecurityEvent securityEvent : securityEventDeque) {
            SignedElementSecurityEvent signedElementSecurityEvent;
            if (!WSSecurityEventConstants.SignedElement.equals((Object)securityEvent.getSecurityEventType()) || !(signedElementSecurityEvent = (SignedElementSecurityEvent)securityEvent).isSigned() || tokenSecurityEvent.getSecurityToken() == null || signedElementSecurityEvent.getXmlSecEvent() == null || signedElementSecurityEvent.getXmlSecEvent() != ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getXMLSecEvent() || securityTokenList.contains((InboundSecurityToken)signedElementSecurityEvent.getSecurityToken())) continue;
            securityTokenList.add((InboundSecurityToken)signedElementSecurityEvent.getSecurityToken());
        }
        return securityTokenList;
    }

    private List<InboundSecurityToken> isEncryptedToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, Deque<SecurityEvent> securityEventDeque, HttpsTokenSecurityEvent httpsTokenSecurityEvent) throws XMLSecurityException {
        ArrayList<InboundSecurityToken> securityTokenList = new ArrayList<InboundSecurityToken>();
        if (httpsTokenSecurityEvent != null) {
            securityTokenList.add((InboundSecurityToken)httpsTokenSecurityEvent.getSecurityToken());
            return securityTokenList;
        }
        for (SecurityEvent securityEvent : securityEventDeque) {
            EncryptedElementSecurityEvent encryptedElementSecurityEvent;
            if (!WSSecurityEventConstants.EncryptedElement.equals((Object)securityEvent.getSecurityEventType()) || !(encryptedElementSecurityEvent = (EncryptedElementSecurityEvent)securityEvent).isEncrypted() || tokenSecurityEvent.getSecurityToken() == null || encryptedElementSecurityEvent.getXmlSecEvent() == null || encryptedElementSecurityEvent.getXmlSecEvent() != ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getXMLSecEvent() || securityTokenList.contains((InboundSecurityToken)encryptedElementSecurityEvent.getSecurityToken())) continue;
            securityTokenList.add((InboundSecurityToken)encryptedElementSecurityEvent.getSecurityToken());
        }
        return securityTokenList;
    }

    private boolean signsElement(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, List<QName> elementPath, Deque<SecurityEvent> securityEventDeque) throws XMLSecurityException {
        for (SecurityEvent securityEvent : securityEventDeque) {
            SignedElementSecurityEvent signedElementSecurityEvent;
            if (!WSSecurityEventConstants.SignedElement.equals((Object)securityEvent.getSecurityEventType()) || !(signedElementSecurityEvent = (SignedElementSecurityEvent)securityEvent).isSigned() || !this.matchesTokenOrWrappedTokenId(tokenSecurityEvent.getSecurityToken(), signedElementSecurityEvent.getSecurityToken().getId(), SecurityTokenConstants.TokenUsage_Signature) || !WSSUtils.pathMatches(elementPath, signedElementSecurityEvent.getElementPath(), true, false)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesTokenOrWrappedTokenId(SecurityToken securityToken, String id, SecurityTokenConstants.TokenUsage tokenUsage) throws XMLSecurityException {
        if (securityToken.getId().equals(id) && securityToken.getTokenUsages().contains(tokenUsage)) {
            return true;
        }
        List wrappedTokens = securityToken.getWrappedTokens();
        for (int i = 0; i < wrappedTokens.size(); ++i) {
            boolean match = this.matchesTokenOrWrappedTokenId((SecurityToken)wrappedTokens.get(i), id, tokenUsage);
            if (!match) continue;
            return match;
        }
        return false;
    }

    private boolean encryptsElement(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, List<QName> elementPath, Deque<SecurityEvent> securityEventDeque) throws XMLSecurityException {
        for (SecurityEvent securityEvent : securityEventDeque) {
            ContentEncryptedElementSecurityEvent contentEncryptedElementSecurityEvent;
            EncryptedElementSecurityEvent encryptedElementSecurityEvent;
            if (!(WSSecurityEventConstants.EncryptedElement.equals((Object)securityEvent.getSecurityEventType()) ? (encryptedElementSecurityEvent = (EncryptedElementSecurityEvent)securityEvent).isEncrypted() && encryptedElementSecurityEvent.getSecurityToken().getId().equals(tokenSecurityEvent.getSecurityToken().getId()) && WSSUtils.pathMatches(elementPath, encryptedElementSecurityEvent.getElementPath(), true, false) : WSSecurityEventConstants.ContentEncrypted.equals((Object)securityEvent.getSecurityEventType()) && (contentEncryptedElementSecurityEvent = (ContentEncryptedElementSecurityEvent)securityEvent).isEncrypted() && contentEncryptedElementSecurityEvent.getSecurityToken().getId().equals(tokenSecurityEvent.getSecurityToken().getId()) && contentEncryptedElementSecurityEvent.getXmlSecEvent() == ((InboundSecurityToken)tokenSecurityEvent.getSecurityToken()).getXMLSecEvent() && WSSUtils.pathMatches(elementPath, contentEncryptedElementSecurityEvent.getElementPath(), true, false))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleBSPRule(BSPRule bspRule) throws WSSecurityException {
        if (this.disableBSPEnforcement) {
            return;
        }
        if (!this.ignoredBSPRules.contains(bspRule)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "empty", new Object[]{"BSP:" + bspRule.name() + ": " + bspRule.getMsg()});
        }
        LOG.warn("BSP:" + bspRule.name() + ": " + bspRule.getMsg());
    }

    @Override
    public void ignoredBSPRules(List<BSPRule> bspRules) {
        this.ignoredBSPRules = new ArrayList<BSPRule>(bspRules);
    }

    public boolean isDisableBSPEnforcement() {
        return this.disableBSPEnforcement;
    }

    public void setDisableBSPEnforcement(boolean disableBSPEnforcement) {
        this.disableBSPEnforcement = disableBSPEnforcement;
    }

    public boolean isAllowRSA15KeyTransportAlgorithm() {
        return this.allowRSA15KeyTransportAlgorithm;
    }

    public void setAllowRSA15KeyTransportAlgorithm(boolean allowRSA15KeyTransportAlgorithm) {
        this.allowRSA15KeyTransportAlgorithm = allowRSA15KeyTransportAlgorithm;
    }
}

