/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.LocalRegistry;

public class LocalRegistryFactory<K, V>
implements RegistryFactory<K, V> {
    final AtomicReference<RegistryEntryProvider<K, V>> provider = new AtomicReference();
    private final Group group;

    public LocalRegistryFactory(Group group) {
        this.group = group;
    }

    public Registry<K, V> createRegistry(RegistryEntryProvider<K, V> provider) {
        if (!this.provider.compareAndSet(null, provider)) {
            throw new IllegalStateException();
        }
        return new LocalRegistry<K, V>(this.group, provider){

            @Override
            public void close() {
                super.close();
                LocalRegistryFactory.this.provider.set(null);
            }
        };
    }
}

