/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import org.hawkular.agent.monitor.cmd.AbstractDMRResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.dmr.api.DmrApiException;
import org.hawkular.dmr.api.OperationBuilder;
import org.jboss.as.controller.client.ModelControllerClient;

public abstract class AbstractRemoveModelNodeCommand<Q extends ResourcePathRequest, S extends ResourcePathResponse>
extends AbstractDMRResourcePathCommand<Q, S> {
    private static final MsgLogger log = AgentLoggers.getLogger(AbstractRemoveModelNodeCommand.class);

    public AbstractRemoveModelNodeCommand(String entityType) {
        super("Remove", entityType);
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<Q> envelope, S response, CommandContext context, DMRSession dmrContext) throws Exception {
        OperationBuilder.OperationResult opResult;
        try {
            opResult = ((OperationBuilder.RemoveOperationBuilder)OperationBuilder.remove().address().segments(modelNodePath).parentBuilder()).execute(controllerClient).assertSuccess();
        }
        catch (DmrApiException e) {
            log.warnf("Attempt #2 to remove resource [%s], see JIRA WFLY-5528", modelNodePath);
            opResult = ((OperationBuilder.RemoveOperationBuilder)OperationBuilder.remove().address().segments(modelNodePath).parentBuilder()).execute(controllerClient).assertSuccess();
        }
        this.setServerRefreshIndicator(opResult, response);
        DMRNodeLocation doomedLocation = DMRNodeLocation.of(modelNodePath);
        endpointService.removeResources(doomedLocation);
        endpointService.discoverAll();
        return null;
    }
}

