/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.ArrayList;
import java.util.List;
import org.hawkular.agent.monitor.cmd.FeedCommProcessor;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.service.AgentCoreEngine;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;

public class CommandContext {
    private final FeedCommProcessor feedComm;
    private final AgentCoreEngine agentCoreEngine;
    private final List<ResponseSentListener> sentListeners;

    public CommandContext(FeedCommProcessor feedCommProcessor, AgentCoreEngine agentCoreEngine) {
        this.feedComm = feedCommProcessor;
        this.agentCoreEngine = agentCoreEngine;
        this.sentListeners = new ArrayList<ResponseSentListener>(0);
    }

    public FeedCommProcessor getFeedCommProcessor() {
        return this.feedComm;
    }

    public AgentCoreEngineConfiguration getAgentCoreEngineConfiguration() {
        return this.agentCoreEngine.getConfiguration();
    }

    public AgentCoreEngine getAgentCoreEngine() {
        return this.agentCoreEngine;
    }

    public void addResponseSentListener(ResponseSentListener listener) {
        this.sentListeners.add(listener);
    }

    List<ResponseSentListener> getResponseSentListeners() {
        return this.sentListeners;
    }

    public static interface ResponseSentListener {
        public void onSend(BasicMessageWithExtraData<? extends BasicMessage> var1, Exception var2);
    }
}

