/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.cmd.AbstractJMXResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.OperationParam;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.jmx.JMXDriver;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ExecuteOperationRequest;
import org.hawkular.cmdgw.api.ExecuteOperationResponse;

public class ExecuteJMXOperationCommand
extends AbstractJMXResourcePathCommand<ExecuteOperationRequest, ExecuteOperationResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(ExecuteJMXOperationCommand.class);

    public ExecuteJMXOperationCommand() {
        super("Execute Operation", "JMX MBean");
    }

    @Override
    protected ExecuteOperationResponse createResponse() {
        return new ExecuteOperationResponse();
    }

    @Override
    protected String getOperationName(BasicMessageWithExtraData<ExecuteOperationRequest> envelope) {
        return ((ExecuteOperationRequest)envelope.getBasicMessage()).getOperationName();
    }

    @Override
    protected void validate(BasicMessageWithExtraData<ExecuteOperationRequest> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
    }

    @Override
    protected boolean modifiesResource() {
        return false;
    }

    @Override
    protected BinaryData execute(EndpointService<JMXNodeLocation, JMXSession> endpointService, String resourceId, BasicMessageWithExtraData<ExecuteOperationRequest> envelope, ExecuteOperationResponse response, CommandContext context) throws Exception {
        ExecuteOperationRequest request = (ExecuteOperationRequest)envelope.getBasicMessage();
        ResourceManager<JMXNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<JMXNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot execute operation: unknown resource [%s]", request.getResourcePath()));
        }
        JMXNodeLocation opLocation = null;
        Operation<JMXNodeLocation> theOperation = null;
        try (JMXSession session = endpointService.openSession();){
            List<OperationParam> opSignature;
            String requestedOpName = request.getOperationName();
            Collection<Operation<JMXNodeLocation>> ops = resource.getResourceType().getOperations();
            log.tracef("Searching for operation [%s] among operations [%s] for resource [%s].", requestedOpName, ops, resource.getID());
            for (Operation<JMXNodeLocation> op : ops) {
                if (!requestedOpName.equals(op.getName().getNameString())) continue;
                opLocation = (JMXNodeLocation)session.getLocationResolver().absolutize(resource.getLocation(), op.getLocation());
                theOperation = op;
                if (!op.getModifies() || !context.getAgentCoreEngine().isImmutable()) break;
                throw new IllegalStateException("Operation [" + requestedOpName + "] not allowed because the agent is immutable");
            }
            if (opLocation == null) {
                throw new IllegalArgumentException(String.format("Cannot execute operation: unknown operation [%s] for resource [%s]", request.getOperationName(), resource));
            }
            response.setOperationName(request.getOperationName());
            Map argsMap = request.getParameters();
            if (argsMap == null) {
                argsMap = Collections.emptyMap();
            }
            Object[] args = new Object[(opSignature = theOperation.getParameters()) == null ? 0 : opSignature.size()];
            Class[] signature = new Class[opSignature == null ? 0 : opSignature.size()];
            int i = 0;
            for (OperationParam opParam : opSignature) {
                this.guessJavaType(opParam, (String)argsMap.get(opParam.getName()), i++, args, signature);
            }
            ObjectName targetMBean = opLocation.getObjectName();
            String internalOpName = theOperation.getInternalName();
            JMXDriver jmxDriver = (JMXDriver)session.getDriver();
            Object results = jmxDriver.executeOperation(targetMBean, internalOpName, args, signature);
            if (results != null) {
                response.setMessage(results.toString());
            }
        }
        endpointService.discoverAll();
        return null;
    }

    private void guessJavaType(OperationParam paramDef, String valueStr, int arrayIndex, Object[] argArray, Class<?>[] sigArray) throws Exception {
        String typeStr = paramDef.getType();
        if (valueStr == null) {
            valueStr = paramDef.getDefaultValue();
        }
        Class realType = null;
        Object value = null;
        if (typeStr == null || typeStr.equalsIgnoreCase("string")) {
            realType = String.class;
            value = valueStr;
        } else {
            boolean isPrim = Character.isLowerCase(typeStr.charAt(0));
            if (typeStr.equalsIgnoreCase("int") || typeStr.equalsIgnoreCase("integer")) {
                Class<Object> clazz = realType = isPrim ? Integer.TYPE : Integer.class;
                value = valueStr == null ? (isPrim ? Integer.valueOf(0) : null) : Integer.valueOf(valueStr);
            } else if (typeStr.equalsIgnoreCase("bool") || typeStr.equalsIgnoreCase("boolean")) {
                Class<Object> clazz = realType = isPrim ? Boolean.TYPE : Boolean.class;
                value = valueStr == null ? (isPrim ? Boolean.FALSE : null) : Boolean.valueOf(valueStr);
            } else if (typeStr.equalsIgnoreCase("long")) {
                Class<Object> clazz = realType = isPrim ? Long.TYPE : Long.class;
                value = valueStr == null ? (isPrim ? Long.valueOf(0L) : null) : Long.valueOf(valueStr);
            } else if (typeStr.equalsIgnoreCase("double")) {
                Class<Object> clazz = realType = isPrim ? Double.TYPE : Double.class;
                value = valueStr == null ? (isPrim ? Double.valueOf(0.0) : null) : Double.valueOf(valueStr);
            } else if (typeStr.equalsIgnoreCase("float")) {
                Class<Object> clazz = realType = isPrim ? Float.TYPE : Float.class;
                value = valueStr == null ? (isPrim ? Float.valueOf(0.0f) : null) : Float.valueOf(valueStr);
            } else if (typeStr.equalsIgnoreCase("short")) {
                Class<Object> clazz = realType = isPrim ? Short.TYPE : Short.class;
                value = valueStr == null ? (isPrim ? Short.valueOf((short)0) : null) : Short.valueOf(valueStr);
            } else if (typeStr.equalsIgnoreCase("char") || typeStr.equalsIgnoreCase("character")) {
                Class<Object> clazz = realType = isPrim ? Character.TYPE : Character.class;
                value = valueStr == null || valueStr.isEmpty() ? (isPrim ? Character.valueOf('\u0000') : null) : Character.valueOf(valueStr.charAt(0));
            } else if (typeStr.equalsIgnoreCase("byte")) {
                Class<Object> clazz = realType = isPrim ? Byte.TYPE : Byte.class;
                value = valueStr == null ? (isPrim ? Byte.valueOf((byte)0) : null) : Byte.valueOf(valueStr);
            } else {
                throw new UnsupportedOperationException("Cannot support operation with param type of [" + typeStr + "]");
            }
        }
        argArray[arrayIndex] = value;
        sigArray[arrayIndex] = realType;
    }
}

