/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import java.io.IOException;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRDriver;
import org.hawkular.agent.monitor.protocol.dmr.DMRLocationResolver;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.dmr.api.OperationBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class DMREndpointService
extends EndpointService<DMRNodeLocation, DMRSession> {
    private final ModelControllerClientFactory modelControllerClientFactory;

    public static String lookupServerIdentifier(ModelControllerClient client) throws IOException {
        ModelNode rootNode = OperationBuilder.readResource().includeRuntime().execute(client).assertSuccess().getResultNode();
        String hostName = null;
        if (rootNode.hasDefined("local-host-name")) {
            hostName = rootNode.get("local-host-name").asString();
        } else if (rootNode.hasDefined("host")) {
            hostName = rootNode.get("host").asString();
        }
        String serverName = null;
        if (rootNode.hasDefined("name")) {
            serverName = rootNode.get("name").asString();
        }
        String uuid = rootNode.hasDefined("uuid") ? rootNode.get("uuid").asString() : null;
        String nodeName = System.getProperty("jboss.node.name");
        return DMREndpointService.getServerIdentifier(hostName, serverName, nodeName, uuid);
    }

    static String getServerIdentifier(String hostName, String serverName, String nodeName, String uuid) {
        if (uuid != null) {
            return uuid;
        }
        StringBuilder fullId = new StringBuilder();
        if (hostName != null && !hostName.isEmpty()) {
            if (fullId.length() > 0) {
                fullId.append('.');
            }
            fullId.append(hostName);
        }
        if (serverName != null && !serverName.isEmpty()) {
            if (fullId.length() > 0) {
                fullId.append('.');
            }
            fullId.append(serverName);
        }
        if (nodeName != null && !nodeName.isEmpty() && !nodeName.equals(serverName)) {
            if (fullId.length() > 0) {
                fullId.append('.');
            }
            fullId.append(nodeName);
        }
        return fullId.toString();
    }

    public DMREndpointService(String feedId, MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint, ResourceTypeManager<DMRNodeLocation> resourceTypeManager, ModelControllerClientFactory modelControllerClientFactory, ProtocolDiagnostics diagnostics) {
        super(feedId, endpoint, resourceTypeManager, new DMRLocationResolver(), diagnostics);
        this.modelControllerClientFactory = modelControllerClientFactory;
    }

    @Override
    public DMRSession openSession() {
        ModelControllerClient client = this.modelControllerClientFactory.createClient();
        DMRDriver driver = new DMRDriver(client, this.getMonitoredEndpoint(), this.getDiagnostics());
        return new DMRSession(this.getFeedId(), this.getMonitoredEndpoint(), this.getResourceTypeManager(), driver, this.getLocationResolver(), client);
    }
}

