/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.common.AbstractDisks;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.DiskArbitration;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.SystemB;
import oshi.util.platform.mac.CfUtil;
import oshi.util.platform.mac.IOKitUtil;

public class MacDisks
extends AbstractDisks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacDisks.class);

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        int numfs = SystemB.INSTANCE.getfsstat64(null, 0, 0);
        SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
        numfs = SystemB.INSTANCE.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
        DiskArbitration.DASessionRef session = DiskArbitration.INSTANCE.DASessionCreate(CfUtil.ALLOCATOR);
        if (session == null) {
            LOG.error("Unable to open session to DiskArbitration framework.");
            return new HWDiskStore[0];
        }
        for (SystemB.Statfs f : fs) {
            String model = "";
            String serial = "";
            long size = 0L;
            long read = 0L;
            long write = 0L;
            String[] split = new String(f.f_mntfromname).trim().split("/dev/|s2");
            if (split.length < 2) continue;
            String bsdName = split[1];
            String path = "/dev/" + bsdName;
            DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromBSDName(CfUtil.ALLOCATOR, session, path);
            if (disk == null) continue;
            CoreFoundation.CFDictionaryRef diskInfo = DiskArbitration.INSTANCE.DADiskCopyDescription(disk);
            if (diskInfo != null) {
                Pointer modelPtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, CfUtil.getCFString("DADeviceModel"));
                model = CfUtil.cfPointerToString(modelPtr);
                Pointer sizePtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, CfUtil.getCFString("DAMediaSize"));
                size = CfUtil.cfPointerToLong(sizePtr);
                CfUtil.release(diskInfo);
                if (!model.equals("Disk Image")) {
                    CoreFoundation.CFStringRef modelNameRef = CoreFoundation.CFStringRef.toCFString(model);
                    CoreFoundation.CFMutableDictionaryRef propertyDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
                    CoreFoundation.INSTANCE.CFDictionarySetValue(propertyDict, CfUtil.getCFString("Model"), modelNameRef);
                    CoreFoundation.CFMutableDictionaryRef matchingDict = CoreFoundation.INSTANCE.CFDictionaryCreateMutable(CfUtil.ALLOCATOR, 0, null, null);
                    CoreFoundation.INSTANCE.CFDictionarySetValue(matchingDict, CfUtil.getCFString("IOPropertyMatch"), propertyDict);
                    IntByReference serviceIterator = new IntByReference();
                    IOKitUtil.getMatchingServices(matchingDict, serviceIterator);
                    CfUtil.release(modelNameRef);
                    CfUtil.release(propertyDict);
                    int sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
                    while (sdService != 0) {
                        serial = IOKitUtil.getIORegistryStringProperty(sdService, "Serial Number");
                        IOKit.INSTANCE.IOObjectRelease(sdService);
                        if (serial != null) break;
                        sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
                    }
                    IOKit.INSTANCE.IOObjectRelease(serviceIterator.getValue());
                }
            }
            CfUtil.release(disk);
            CoreFoundation.CFMutableDictionaryRef matchingDict = IOKitUtil.getBSDNameMatchingDict(bsdName);
            if (matchingDict != null) {
                IntByReference driveList = new IntByReference();
                IOKitUtil.getMatchingServices(matchingDict, driveList);
                int drive = IOKit.INSTANCE.IOIteratorNext(driveList.getValue());
                if (drive != 0) {
                    IntByReference parent = new IntByReference();
                    if (IOKit.INSTANCE.IOObjectConformsTo(drive, "IOMedia") && IOKit.INSTANCE.IORegistryEntryGetParentEntry(drive, "IOService", parent) == 0) {
                        PointerByReference propsPtr = new PointerByReference();
                        if (IOKit.INSTANCE.IOObjectConformsTo(parent.getValue(), "IOBlockStorageDriver") && IOKit.INSTANCE.IORegistryEntryCreateCFProperties(parent.getValue(), propsPtr, CfUtil.ALLOCATOR, 0) == 0) {
                            CoreFoundation.CFMutableDictionaryRef properties = new CoreFoundation.CFMutableDictionaryRef();
                            properties.setPointer(propsPtr.getValue());
                            Pointer statsPtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(properties, CfUtil.getCFString("Statistics"));
                            CoreFoundation.CFDictionaryRef statistics = new CoreFoundation.CFDictionaryRef();
                            statistics.setPointer(statsPtr);
                            Pointer stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Bytes (Read)"));
                            read = CfUtil.cfPointerToLong(stat);
                            stat = CoreFoundation.INSTANCE.CFDictionaryGetValue(statistics, CfUtil.getCFString("Bytes (Write)"));
                            write = CfUtil.cfPointerToLong(stat);
                            CfUtil.release(properties);
                        } else {
                            LOG.error("Unable to find block storage driver properties for {}", (Object)bsdName);
                        }
                        IOKit.INSTANCE.IOObjectRelease(parent.getValue());
                    } else {
                        LOG.error("Unable to find IOMedia device or parent for ", (Object)bsdName);
                    }
                    IOKit.INSTANCE.IOObjectRelease(drive);
                }
                IOKit.INSTANCE.IOObjectRelease(driveList.getValue());
            }
            if (size <= 0L) continue;
            result.add(new HWDiskStore(bsdName, model.trim(), serial.trim(), size, read, write));
        }
        CfUtil.release(session);
        return result.toArray(new HWDiskStore[result.size()]);
    }
}

