/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.DocumentUtil;
import org.w3c.dom.Element;

public class KeyUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static String EOL = KeyUtil.getSystemProperty("line.separator", "\n");

    public static String encodeAsString(Certificate certificate) throws CertificateEncodingException {
        return Base64.encodeBytes((byte[])certificate.getEncoded());
    }

    public static Element getKeyInfo(Certificate certificate) throws CertificateException, ConfigurationException, ParsingException, ProcessingException {
        if (certificate == null) {
            throw logger.nullArgumentError("certificate is null");
        }
        StringBuilder builder = new StringBuilder();
        if (!(certificate instanceof X509Certificate)) {
            throw logger.notImplementedYet("Only X509Certificate are supported");
        }
        X509Certificate x509 = (X509Certificate)certificate;
        String certStr = Base64.encodeBytes((byte[])x509.getEncoded(), (int)76);
        builder.append("<KeyInfo xmlns='http://www.w3.org/2000/09/xmldsig#'>").append(EOL).append("<X509Data>").append(EOL).append("<X509Certificate>").append(EOL).append(certStr).append(EOL).append("</X509Certificate>").append("</X509Data>").append("</KeyInfo>");
        return DocumentUtil.getDocument((String)builder.toString()).getDocumentElement();
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }
}

