/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model.validator;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class RequiredChildValidationStepHandler
implements ModelValidationStepHandler {
    private final ModelElement childElement;

    public RequiredChildValidationStepHandler(ModelElement childElement) {
        this.childElement = childElement;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validateRequiredChild(context, operation);
        context.stepCompleted();
    }

    protected void validateRequiredChild(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        Set children = resource.getChildren(this.childElement.getName());
        if (children.isEmpty()) {
            throw PicketLinkLogger.ROOT_LOGGER.requiredChild(pathAddress.getLastElement().toString(), this.childElement.getName());
        }
    }
}

