/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Single;
import rx.SingleSubscriber;
import rx.exceptions.AssemblyStackTraceException;
import rx.internal.operators.OnSubscribeOnAssembly;

public final class OnSubscribeOnAssemblySingle<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final String stacktrace;
    public static volatile boolean fullStackTrace;

    public OnSubscribeOnAssemblySingle(Single.OnSubscribe<T> source) {
        this.source = source;
        this.stacktrace = OnSubscribeOnAssembly.createStacktrace();
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        this.source.call(new OnAssemblySingleSubscriber<T>(t, this.stacktrace));
    }

    static final class OnAssemblySingleSubscriber<T>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super T> actual;
        final String stacktrace;

        public OnAssemblySingleSubscriber(SingleSubscriber<? super T> actual, String stacktrace) {
            this.actual = actual;
            this.stacktrace = stacktrace;
            actual.add(this);
        }

        @Override
        public void onError(Throwable e) {
            e = new AssemblyStackTraceException(this.stacktrace, e);
            this.actual.onError(e);
        }

        @Override
        public void onSuccess(T t) {
            this.actual.onSuccess(t);
        }
    }
}

