/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Supplier;
import org.hawkular.inventory.api.model.AbstractHashTree;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;

public class GenericHashTreeDeserializer<T extends AbstractHashTree<T, H>, H extends Serializable>
extends JsonDeserializer<T> {
    private final Supplier<AbstractHashTree.TopBuilder<?, ?, T, H>> topBuilderSupplier;
    private final Class<H> hashType;

    public GenericHashTreeDeserializer(Supplier<AbstractHashTree.TopBuilder<?, ?, T, H>> topBuilderSupplier, Class<H> hashType) {
        this.topBuilderSupplier = topBuilderSupplier;
        this.hashType = hashType;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        AbstractHashTree.TopBuilder<?, ?, T, H> bld = this.topBuilderSupplier.get();
        RelativePath.Extender emptyPath = RelativePath.empty();
        this.deserializeChild(p, (AbstractHashTree.Builder<?, ?, T, H>)bld, emptyPath, ctxt);
        return (T)bld.build();
    }

    private void deserializeChildren(JsonParser p, AbstractHashTree.Builder<?, ?, T, H> bld, RelativePath.Extender parentPath, DeserializationContext ctx) throws IOException {
        RelativePath.Extender origParentPath = parentPath;
        parentPath = origParentPath.get().modified();
        RelativePath childPath = null;
        while (p.nextToken() != null) {
            switch (p.getCurrentToken()) {
                case FIELD_NAME: {
                    childPath = parentPath.extend(Path.Segment.from((String)p.getCurrentName())).get();
                    break;
                }
                case START_OBJECT: {
                    AbstractHashTree.ChildBuilder childBld = bld.startChild();
                    this.deserializeChild(p, (AbstractHashTree.Builder<?, ?, T, H>)childBld, childPath.modified(), ctx);
                    childBld.endChild();
                    parentPath = origParentPath.get().modified();
                    break;
                }
                case END_OBJECT: {
                    return;
                }
            }
        }
    }

    private void deserializeChild(JsonParser p, AbstractHashTree.Builder<?, ?, T, H> bld, RelativePath.Extender childPath, DeserializationContext ctx) throws IOException {
        bld.withPath(childPath.get());
        String currentField = null;
        block12: while (p.nextToken() != null) {
            switch (p.getCurrentToken()) {
                case END_OBJECT: {
                    return;
                }
                case FIELD_NAME: {
                    currentField = p.getCurrentName();
                    continue block12;
                }
            }
            switch (currentField) {
                case "hash": {
                    Serializable hash = (Serializable)ctx.readValue(p, this.hashType);
                    bld.withHash(hash);
                    break;
                }
                case "children": {
                    this.deserializeChildren(p, bld, childPath, ctx);
                }
            }
        }
    }
}

