/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.hawkular.inventory.api.model.StructuredData;

public final class StructuredDataSerializer
extends JsonSerializer<StructuredData> {
    public void serialize(StructuredData value, final JsonGenerator jgen, SerializerProvider provider) throws IOException {
        value.accept((StructuredData.Visitor)new StructuredData.Visitor.Simple<Void, Void>(){

            public Void visitBool(boolean value, Void parameter) {
                try {
                    jgen.writeBoolean(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            public Void visitIntegral(long value, Void parameter) {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            public Void visitFloatingPoint(double value, Void parameter) {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            public Void visitString(String value, Void parameter) {
                try {
                    jgen.writeString(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            public Void visitUndefined(Void parameter) {
                try {
                    jgen.writeNull();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            public Void visitList(List<StructuredData> value, Void parameter) {
                try {
                    jgen.writeStartArray();
                    for (StructuredData m : value) {
                        m.accept((StructuredData.Visitor)this, null);
                    }
                    jgen.writeEndArray();
                    return null;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write structured data.", e);
                }
            }

            public Void visitMap(Map<String, StructuredData> value, Void parameter) {
                try {
                    jgen.writeStartObject();
                    for (Map.Entry<String, StructuredData> e : value.entrySet()) {
                        jgen.writeFieldName(e.getKey());
                        e.getValue().accept((StructuredData.Visitor)this, null);
                    }
                    jgen.writeEndObject();
                    return null;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write structured data.", e);
                }
            }
        }, null);
    }
}

