/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.security.manager._private.SecurityMessages;
import org.wildfly.security.permission.ElytronPermission;

final class ElytronPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    private transient AtomicInteger set = new AtomicInteger(0);
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("p1", Integer.TYPE)};

    ElytronPermissionCollection() {
    }

    @Override
    public void add(Permission permission) throws SecurityException, IllegalArgumentException {
        if (this.isReadOnly()) {
            throw SecurityMessages.permission.readOnlyPermCollection();
        }
        if (!(permission instanceof ElytronPermission)) {
            throw SecurityMessages.permission.wrongPermType(ElytronPermission.class, permission);
        }
        this.setBit(((ElytronPermission)permission).getKind().ordinal());
    }

    private void setBit(int bit) {
        int oldVal;
        AtomicInteger set = this.set;
        int value = 1 << bit;
        do {
            if (((oldVal = set.get()) & value) == 0) continue;
            return;
        } while (!set.compareAndSet(oldVal, oldVal | value));
    }

    public boolean isSet(int bit) {
        return (this.set.get() & 1 << bit) != 0;
    }

    @Override
    public boolean implies(Permission permission) {
        return permission instanceof ElytronPermission && this.isSet(((ElytronPermission)permission).getKind().ordinal());
    }

    @Override
    public Enumeration<Permission> elements() {
        final int value = this.set.get();
        if (value == 0) {
            return Collections.emptyEnumeration();
        }
        return new Enumeration<Permission>(){
            private int bits;
            {
                this.bits = value;
            }

            @Override
            public boolean hasMoreElements() {
                return this.bits != 0;
            }

            @Override
            public Permission nextElement() {
                int bit = Integer.lowestOneBit(this.bits);
                if (bit == 0) {
                    throw new NoSuchElementException();
                }
                this.bits &= ~bit;
                return ElytronPermission.values[Integer.numberOfTrailingZeros(bit)].getPermission();
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof ElytronPermissionCollection && this.set.get() == ((ElytronPermissionCollection)obj).set.get();
    }

    public int hashCode() {
        return this.set.get() * 3559 + 7477;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        int value = getField.get("p1", 0);
        this.set = new AtomicInteger();
        this.set.lazySet(value);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        putField.put("p1", this.set.get());
        oos.writeFields();
    }
}

