/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import org.hawkular.agent.monitor.cmd.Command;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.ResponseStatus;

public abstract class AbstractResourcePathCommand<REQ extends ResourcePathRequest, RESP extends ResourcePathResponse>
implements Command<REQ, RESP> {
    private final String operationName;
    private final String entityType;

    public AbstractResourcePathCommand(String operationName, String entityType) {
        this.operationName = operationName;
        this.entityType = entityType;
    }

    protected String getOperationName(BasicMessageWithExtraData<REQ> envelope) {
        return this.operationName;
    }

    protected String getEntityType(BasicMessageWithExtraData<REQ> envelope) {
        return this.entityType;
    }

    protected void validate(BasicMessageWithExtraData<REQ> envelope) {
        if (((ResourcePathRequest)envelope.getBasicMessage()).getResourcePath() == null) {
            throw new IllegalArgumentException(String.format("resourcePath of a [%s] cannot be null", envelope.getClass().getName()));
        }
    }

    protected abstract void validate(BasicMessageWithExtraData<REQ> var1, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> var2);

    protected abstract RESP createResponse();

    protected void success(BasicMessageWithExtraData<REQ> envelope, RESP response) {
        response.setStatus(ResponseStatus.OK);
        String msg = String.format("Performed [%s] on a [%s] given by Inventory path [%s]", this.getOperationName(envelope), this.entityType, ((ResourcePathRequest)envelope.getBasicMessage()).getResourcePath());
        String innerMessage = response.getMessage();
        if (innerMessage != null) {
            msg = msg + ": " + innerMessage;
        }
        response.setMessage(msg);
    }

    protected void assertLocalDMRServer(MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
        if (!endpoint.isLocal()) {
            String envVar = "JBOSS_HOME_ENV_VAR";
            String sysProp = "jboss.home.dir";
            String envVarValue = System.getenv(envVar);
            if (envVarValue != null) {
                return;
            }
            String sysPropValue = System.getProperty(sysProp, null);
            if (sysPropValue != null) {
                return;
            }
            throw new IllegalStateException(String.format("Cannot perform [%s] on a [%s] on a non local instance of [%s].", this.operationName, this.entityType, endpoint.getName()));
        }
    }

    protected boolean modifiesResource() {
        return true;
    }
}

