/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.AccessDelegate;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class InvalidationCacheAccessDelegate
implements AccessDelegate {
    protected static final Log log = LogFactory.getLog(InvalidationCacheAccessDelegate.class);
    protected static final boolean TRACE_ENABLED = log.isTraceEnabled();
    protected final AdvancedCache cache;
    protected final BaseRegion region;
    protected final PutFromLoadValidator putValidator;
    protected final AdvancedCache<Object, Object> writeCache;

    protected InvalidationCacheAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        this.region = region;
        this.cache = region.getCache();
        this.putValidator = validator;
        this.writeCache = Caches.ignoreReturnValuesCache(this.cache);
    }

    @Override
    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        if (!this.region.checkValid()) {
            return null;
        }
        Object val = this.cache.get(key);
        if (val == null) {
            this.putValidator.registerPendingPut(session, key, txTimestamp);
        }
        return val;
    }

    @Override
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (!this.region.checkValid()) {
            if (TRACE_ENABLED) {
                log.tracef("Region %s not valid", (Object)this.region.getName());
            }
            return false;
        }
        if (minimalPutOverride && this.cache.containsKey(key)) {
            return false;
        }
        PutFromLoadValidator.Lock lock = this.putValidator.acquirePutFromLoadLock(session, key, txTimestamp);
        if (lock == null) {
            if (TRACE_ENABLED) {
                log.tracef("Put from load lock not acquired for key %s", key);
            }
            return false;
        }
        try {
            this.writeCache.putForExternalRead(key, value);
        }
        finally {
            this.putValidator.releasePutFromLoadLock(key, lock);
        }
        return true;
    }

    @Override
    public void remove(SessionImplementor session, Object key) throws CacheException {
        if (!this.putValidator.beginInvalidatingKey(session, key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.remove(key);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
    }

    @Override
    public void removeAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
            }
            Caches.removeAll(this.cache);
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.writeCache.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
            }
            this.region.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    @Override
    public void unlockItem(SessionImplementor session, Object key) throws CacheException {
        if (!this.putValidator.endInvalidatingKey(session, key)) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
    }
}

