/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import oshi.util.FileUtil;

public class ProcUtil {
    public static float getSystemUptimeFromProc() {
        String[] split = FileUtil.getSplitFromFile("/proc/uptime");
        if (split.length > 0) {
            try {
                return Float.parseFloat(split[0]);
            }
            catch (NumberFormatException nfe) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public static File[] getPidFiles() {
        File procdir = new File("/proc");
        final Pattern p = Pattern.compile("\\d+");
        File[] pids = procdir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return p.matcher(file.getName()).matches();
            }
        });
        return pids != null ? pids : new File[]{};
    }
}

