/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.COM.EnumWbemClassObject;
import oshi.jna.platform.windows.COM.WbemClassObject;
import oshi.jna.platform.windows.COM.WbemLocator;
import oshi.jna.platform.windows.COM.WbemServices;
import oshi.jna.platform.windows.Ole32;
import oshi.util.ParseUtil;

public class WmiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WmiUtil.class);
    public static final String DEFAULT_NAMESPACE = "ROOT\\CIMV2";
    private static boolean securityInitialized = false;
    private static ValueType[] STRING_TYPE = new ValueType[]{ValueType.STRING};
    private static ValueType[] UINT32_TYPE = new ValueType[]{ValueType.UINT32};
    private static ValueType[] FLOAT_TYPE = new ValueType[]{ValueType.FLOAT};

    public static Long selectUint32From(String namespace, String wmiClass, String property, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, property, wmiClass, whereClause, UINT32_TYPE);
        if (result.containsKey(property) && !result.get(property).isEmpty()) {
            return (Long)result.get(property).get(0);
        }
        return 0L;
    }

    public static Map<String, List<Long>> selectUint32sFrom(String namespace, String wmiClass, String properties, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, UINT32_TYPE);
        HashMap<String, List<Long>> longMap = new HashMap<String, List<Long>>();
        for (String key : result.keySet()) {
            ArrayList<Long> longList = new ArrayList<Long>();
            for (Object obj : result.get(key)) {
                longList.add((Long)obj);
            }
            longMap.put(key, longList);
        }
        return longMap;
    }

    public static Float selectFloatFrom(String namespace, String wmiClass, String property, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, property, wmiClass, whereClause, FLOAT_TYPE);
        if (result.containsKey(property) && !result.get(property).isEmpty()) {
            return (Float)result.get(property).get(0);
        }
        return Float.valueOf(0.0f);
    }

    public static Map<String, List<Float>> selectFloatsFrom(String namespace, String wmiClass, String properties, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, FLOAT_TYPE);
        HashMap<String, List<Float>> floatMap = new HashMap<String, List<Float>>();
        for (String key : result.keySet()) {
            ArrayList<Float> floatList = new ArrayList<Float>();
            for (Object obj : result.get(key)) {
                floatList.add((Float)obj);
            }
            floatMap.put(key, floatList);
        }
        return floatMap;
    }

    public static String selectStringFrom(String namespace, String wmiClass, String property, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, property, wmiClass, whereClause, STRING_TYPE);
        if (result.containsKey(property) && !result.get(property).isEmpty()) {
            return (String)result.get(property).get(0);
        }
        return "";
    }

    public static Map<String, List<String>> selectStringsFrom(String namespace, String wmiClass, String properties, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, STRING_TYPE);
        HashMap<String, List<String>> strMap = new HashMap<String, List<String>>();
        for (String key : result.keySet()) {
            ArrayList<String> strList = new ArrayList<String>();
            for (Object obj : result.get(key)) {
                strList.add((String)obj);
            }
            strMap.put(key, strList);
        }
        return strMap;
    }

    public static Map<String, List<Object>> selectObjectsFrom(String namespace, String wmiClass, String properties, String whereClause, ValueType[] propertyTypes) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, propertyTypes);
        return result;
    }

    private static Map<String, List<Object>> queryWMI(String namespace, String properties, String wmiClass, String whereClause, ValueType[] propertyTypes) {
        PointerByReference pEnumerator;
        HashMap<String, List<Object>> values = new HashMap<String, List<Object>>();
        String[] props = properties.split(",");
        for (int i = 0; i < props.length; ++i) {
            values.put(props[i], new ArrayList());
        }
        if (!WmiUtil.initCOM()) {
            Ole32.INSTANCE.CoUninitialize();
            return values;
        }
        PointerByReference pSvc = new PointerByReference();
        if (!WmiUtil.connectServer(namespace, pSvc)) {
            Ole32.INSTANCE.CoUninitialize();
            return values;
        }
        WbemServices svc = new WbemServices(pSvc.getValue());
        if (!WmiUtil.selectProperties(svc, pEnumerator = new PointerByReference(), properties, wmiClass, whereClause)) {
            svc.Release();
            Ole32.INSTANCE.CoUninitialize();
            return values;
        }
        EnumWbemClassObject enumerator = new EnumWbemClassObject(pEnumerator.getValue());
        WmiUtil.enumerateProperties(values, enumerator, props, propertyTypes);
        enumerator.Release();
        svc.Release();
        Ole32.INSTANCE.CoUninitialize();
        return values;
    }

    private static boolean initCOM() {
        WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeEx(null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            LOG.error(String.format("Failed to initialize COM library. Error code = 0x%08x", hres.intValue()));
            return false;
        }
        if (securityInitialized) {
            return true;
        }
        hres = Ole32.INSTANCE.CoInitializeSecurity(null, new NativeLong(-1L), null, null, 0, 3, null, 0, null);
        if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
            LOG.error(String.format("Failed to initialize security. Error code = 0x%08x", hres.intValue()));
            Ole32.INSTANCE.CoUninitialize();
            return false;
        }
        securityInitialized = true;
        return true;
    }

    private static boolean connectServer(String namespace, PointerByReference pSvc) {
        WbemLocator loc = WbemLocator.create();
        if (loc == null) {
            return false;
        }
        WinNT.HRESULT hres = loc.ConnectServer(new WTypes.BSTR(namespace), null, null, null, null, null, null, pSvc);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            LOG.error(String.format("Could not connect to namespace %s. Error code = 0x%08x", namespace, hres.intValue()));
            loc.Release();
            Ole32.INSTANCE.CoUninitialize();
            return false;
        }
        LOG.debug("Connected to {} WMI namespace", (Object)namespace);
        loc.Release();
        hres = Ole32.INSTANCE.CoSetProxyBlanket(pSvc.getValue(), 10, 0, null, 3, 3, null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            LOG.error(String.format("Could not set proxy blanket. Error code = 0x%08x", hres.intValue()));
            new WbemServices(pSvc.getValue()).Release();
            Ole32.INSTANCE.CoUninitialize();
            return false;
        }
        return true;
    }

    private static boolean selectProperties(WbemServices svc, PointerByReference pEnumerator, String properties, String wmiClass, String whereClause) {
        String query = String.format("SELECT %s FROM %s %s", properties, wmiClass, whereClause != null ? whereClause : "");
        LOG.debug("Query: {}", (Object)query);
        WinNT.HRESULT hres = svc.ExecQuery(new WTypes.BSTR("WQL"), new WTypes.BSTR(query), new NativeLong(48L), null, pEnumerator);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            LOG.error(String.format("Query '%s' failed. Error code = 0x%08x", query, hres.intValue()));
            svc.Release();
            Ole32.INSTANCE.CoUninitialize();
            return false;
        }
        return true;
    }

    private static void enumerateProperties(Map<String, List<Object>> values, EnumWbemClassObject enumerator, String[] properties, ValueType[] propertyTypes) {
        if (propertyTypes.length > 1 && properties.length != propertyTypes.length) {
            throw new IllegalArgumentException("Property type array size must be 1 or equal to properties array size.");
        }
        PointerByReference pclsObj = new PointerByReference();
        LongByReference uReturn = new LongByReference(0L);
        while (enumerator.getPointer() != Pointer.NULL) {
            WinNT.HRESULT hres = enumerator.Next(new NativeLong(-1L), new NativeLong(1L), pclsObj, uReturn);
            if (0L == uReturn.getValue() || COMUtils.FAILED((WinNT.HRESULT)hres)) {
                enumerator.Release();
                return;
            }
            Variant.VARIANT.ByReference vtProp = new Variant.VARIANT.ByReference();
            WbemClassObject clsObj = new WbemClassObject(pclsObj.getValue());
            for (int p = 0; p < properties.length; ++p) {
                String property = properties[p];
                hres = clsObj.Get(new WTypes.BSTR(property), new NativeLong(0L), vtProp, null, null);
                ValueType propertyType = propertyTypes.length > 1 ? propertyTypes[p] : propertyTypes[0];
                switch (propertyType) {
                    case STRING: {
                        values.get(property).add(vtProp.getValue() == null ? "unknown" : vtProp.stringValue());
                        break;
                    }
                    case UINT32: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : vtProp._variant.__variant.lVal.longValue());
                        break;
                    }
                    case FLOAT: {
                        values.get(property).add(Float.valueOf(vtProp.getValue() == null ? 0.0f : vtProp.floatValue()));
                        break;
                    }
                    case DATETIME: {
                        values.get(property).add(ParseUtil.cimDateTimeToMillis(vtProp.stringValue()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unimplemented enum type: " + propertyType.toString());
                    }
                }
                OleAuto.INSTANCE.VariantClear(vtProp.getPointer());
            }
            clsObj.Release();
        }
    }

    public static enum ValueType {
        STRING,
        UINT32,
        FLOAT,
        DATETIME;

    }
}

