/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication.callback;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.security.auth.callback.MapCallback;
import org.jboss.ws.common.utils.Base64;

public class UsernameTokenCallback
implements DigestCallback {
    static final String NONCE = "nonce";
    static final String CREATED = "created";
    static final String DECODE_NONCE = "decodeNonce";
    private MapCallback info;

    public void init(Map<String, Object> options) {
        this.info = new MapCallback();
        Callback[] callbacks = new Callback[]{this.info};
        options.put("callbacks", callbacks);
    }

    public void preDigest(MessageDigest digest) {
        try {
            String created;
            String nonce = (String)this.info.getInfo(NONCE);
            if (nonce != null) {
                Boolean decodeNonce = (Boolean)this.info.getInfo(DECODE_NONCE);
                byte[] nonceBytes = decodeNonce != false ? Base64.decode((String)nonce) : nonce.getBytes("UTF-8");
                digest.update(nonceBytes);
            }
            if ((created = (String)this.info.getInfo(CREATED)) != null) {
                digest.update(created.getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    public void postDigest(MessageDigest digest) {
    }
}

