/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Function;

public final class TreeTraversal<Node> {
    private final Function<Node, Iterator<Node>> childrenExtractor;

    public TreeTraversal(Function<Node, Iterator<Node>> childrenExtractor) {
        this.childrenExtractor = childrenExtractor;
    }

    public void depthFirst(Node node, Function<Node, Boolean> visitor) {
        Memory stack = new Memory<Iterator<Node>>(){
            private final Deque<Iterator<Node>> stack = new ArrayDeque();

            @Override
            public void store(Iterator<Node> data) {
                this.stack.addFirst(data);
            }

            @Override
            public Iterator<Node> getCurrent() {
                return this.stack.peekFirst();
            }

            @Override
            public void removeCurrent() {
                this.stack.removeFirst();
            }

            @Override
            public boolean hasData() {
                return !this.stack.isEmpty();
            }
        };
        this.traverse(node, stack, visitor);
    }

    public void breadthFirst(Node node, Function<Node, Boolean> visitor) {
        Memory queue = new Memory<Iterator<Node>>(){
            private final Deque<Iterator<Node>> queue = new ArrayDeque();

            @Override
            public void store(Iterator<Node> data) {
                this.queue.addLast(data);
            }

            @Override
            public Iterator<Node> getCurrent() {
                return this.queue.peekFirst();
            }

            @Override
            public void removeCurrent() {
                this.queue.removeFirst();
            }

            @Override
            public boolean hasData() {
                return !this.queue.isEmpty();
            }
        };
        this.traverse(node, queue, visitor);
    }

    private void traverse(Node node, Memory<Iterator<Node>> memory, Function<Node, Boolean> visitor) {
        if (!visitor.apply(node).booleanValue()) {
            return;
        }
        Iterator<Node> children = this.childrenExtractor.apply(node);
        memory.store(children);
        while (memory.hasData()) {
            Iterator<Node> it = memory.getCurrent();
            if (!it.hasNext()) {
                memory.removeCurrent();
                continue;
            }
            node = it.next();
            if (!visitor.apply(node).booleanValue()) continue;
            children = this.childrenExtractor.apply(node);
            memory.store(children);
        }
    }

    private static interface Memory<T> {
        public void store(T var1);

        public T getCurrent();

        public void removeCurrent();

        public boolean hasData();
    }
}

