/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.inventory.api.filters.Filter;

public class RelationFilter
extends Filter {
    private static final RelationFilter[] EMPTY = new RelationFilter[0];

    public static Accumulator by(RelationFilter ... filters) {
        return new Accumulator(filters);
    }

    public static RelationFilter[] all() {
        return EMPTY;
    }

    public static final class Accumulator {
        private final List<RelationFilter> filters = new ArrayList<RelationFilter>();

        private Accumulator(RelationFilter ... fs) {
            for (RelationFilter filter : fs) {
                this.filters.add(filter);
            }
        }

        public Accumulator and(RelationFilter f) {
            this.filters.add(f);
            return this;
        }

        public Accumulator and(RelationFilter ... fs) {
            Collections.addAll(this.filters, fs);
            return this;
        }

        public RelationFilter[] get() {
            return this.filters.toArray(new RelationFilter[this.filters.size()]);
        }
    }
}

