/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import oshi.software.common.AbstractProcess;
import oshi.software.os.OSProcess;

public class WindowsProcess
extends AbstractProcess {
    private static final long serialVersionUID = 1L;
    private static final int UNKNOWN = 0;
    private static final int OTHER = 1;
    private static final int READY = 2;
    private static final int RUNNING = 3;
    private static final int BLOCKED = 4;
    private static final int SUSPENDED_BLOCKED = 5;
    private static final int SUSPENDED_READY = 6;
    private static final int TERMINATED = 7;
    private static final int STOPPED = 8;
    private static final int GROWING = 9;

    public WindowsProcess(String name, String path, int winState, int processID, int parentProcessID, int threadCount, int priority, long virtualSize, long residentSetSize, long kernelTime, long userTime, long startTime, long now) {
        this.name = name;
        this.path = path;
        switch (winState) {
            case 2: 
            case 6: {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 4: 
            case 5: {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 3: {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 9: {
                this.state = OSProcess.State.NEW;
                break;
            }
            case 7: {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 8: {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.processID = processID;
        this.parentProcessID = parentProcessID;
        this.threadCount = threadCount;
        this.priority = priority;
        this.virtualSize = virtualSize;
        this.residentSetSize = residentSetSize;
        this.kernelTime = kernelTime;
        this.userTime = userTime;
        this.startTime = startTime;
        this.upTime = now - startTime;
    }
}

