/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

public abstract class AbstractElement<B extends org.hawkular.inventory.api.model.Blueprint, U extends Update> {
    public static final String ID_PROPERTY = "id";
    private final CanonicalPath path;
    protected final Map<String, Object> properties;

    public static Class<? extends AbstractElement<?, ?>> toElementClass(SegmentType elementType) {
        switch (elementType) {
            case t: {
                return Tenant.class;
            }
            case e: {
                return Environment.class;
            }
            case f: {
                return Feed.class;
            }
            case m: {
                return Metric.class;
            }
            case mt: {
                return MetricType.class;
            }
            case r: {
                return Resource.class;
            }
            case rt: {
                return ResourceType.class;
            }
            case rl: {
                return Relationship.class;
            }
            case d: {
                return DataEntity.class;
            }
            case ot: {
                return OperationType.class;
            }
            case mp: {
                return MetadataPack.class;
            }
        }
        throw new IllegalStateException("There is no " + Entity.class.getName() + " type for " + elementType.getClass().getName() + " '" + elementType.name() + "'");
    }

    AbstractElement() {
        this.properties = null;
        this.path = null;
    }

    AbstractElement(CanonicalPath path, Map<String, Object> properties) {
        if (properties == null) {
            this.properties = null;
        } else {
            this.properties = new HashMap<String, Object>(properties);
            this.properties.remove(ID_PROPERTY);
        }
        this.path = path;
    }

    public static SegmentType segmentTypeFromType(Class<?> cl) {
        if (Tenant.class.equals(cl)) {
            return Tenant.SEGMENT_TYPE;
        }
        if (Environment.class.equals(cl)) {
            return Environment.SEGMENT_TYPE;
        }
        if (Feed.class.equals(cl)) {
            return Feed.SEGMENT_TYPE;
        }
        if (Metric.class.equals(cl)) {
            return Metric.SEGMENT_TYPE;
        }
        if (MetricType.class.equals(cl)) {
            return MetricType.SEGMENT_TYPE;
        }
        if (Resource.class.equals(cl)) {
            return Resource.SEGMENT_TYPE;
        }
        if (ResourceType.class.equals(cl)) {
            return ResourceType.SEGMENT_TYPE;
        }
        if (DataEntity.class.equals(cl)) {
            return DataEntity.SEGMENT_TYPE;
        }
        if (OperationType.class.equals(cl)) {
            return OperationType.SEGMENT_TYPE;
        }
        if (MetadataPack.class.equals(cl)) {
            return MetadataPack.SEGMENT_TYPE;
        }
        if (Relationship.class.equals(cl)) {
            return Relationship.SEGMENT_TYPE;
        }
        if (StructuredData.class.equals(cl)) {
            return StructuredData.SEGMENT_TYPE;
        }
        if (RelativePath.Up.class.equals(cl)) {
            return RelativePath.Up.SEGMENT_TYPE;
        }
        throw new IllegalStateException("There is no " + SegmentType.class.getName() + " for type " + (cl == null ? "null" : cl.getName()));
    }

    public abstract <R, P> R accept(ElementVisitor<R, P> var1, P var2);

    public CanonicalPath getPath() {
        return this.path;
    }

    public String getId() {
        return this.path.getSegment().getElementId();
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    protected static <T> T valueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public abstract Updater<U, ? extends AbstractElement<?, U>> update();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractElement entity = (AbstractElement)o;
        return this.path.equals((Object)entity.path);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public static abstract class Blueprint
    implements org.hawkular.inventory.api.model.Blueprint {
        private final Map<String, Object> properties;

        protected Blueprint(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public static abstract class Builder<B, This extends Builder<B, This>> {
            protected Map<String, Object> properties = new HashMap<String, Object>();

            public This withProperty(String key, Object value) {
                this.properties.put(key, value);
                return this.castThis();
            }

            public This withProperties(Map<String, Object> properties) {
                this.properties.putAll(properties);
                return this.castThis();
            }

            public abstract B build();

            protected This castThis() {
                return (This)this;
            }
        }
    }

    public static final class Updater<U extends Update, E extends AbstractElement<?, U>> {
        private final Function<U, E> updater;

        Updater(Function<U, E> updater) {
            this.updater = updater;
        }

        public E with(U update) {
            return (E)((AbstractElement)this.updater.apply(update));
        }
    }

    public static abstract class Update {
        private final Map<String, Object> properties;

        static <U extends Update, E extends AbstractElement<?, U>> Class<? extends E> getEntityTypeOf(U update) {
            return update.getClass().getEnclosingClass();
        }

        public Update(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public abstract <R, P> R accept(ElementUpdateVisitor<R, P> var1, P var2);

        public static abstract class Builder<U extends Update, This extends Builder<U, This>> {
            protected Map<String, Object> properties;

            private Map<String, Object> getProperties() {
                if (this.properties == null) {
                    this.properties = new HashMap<String, Object>();
                }
                return this.properties;
            }

            public This withProperty(String key, Object value) {
                this.getProperties().put(key, value);
                return this.castThis();
            }

            public This withProperties(Map<String, Object> properties) {
                this.getProperties().putAll(properties);
                return this.castThis();
            }

            public abstract U build();

            protected This castThis() {
                return (This)this;
            }
        }
    }
}

