/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.injection.InjectionTargets;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;

public class WeldClassIntrospector
implements EEClassIntrospector,
Service<EEClassIntrospector> {
    private static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"weld", "weldClassIntrospector"});
    private final InjectedValue<BeanManager> beanManager = new InjectedValue();
    private final ConcurrentMap<Class<?>, InjectionTarget<?>> injectionTargets = new ConcurrentHashMap();

    public static void install(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) {
        WeldClassIntrospector introspector = new WeldClassIntrospector();
        serviceTarget.addService(WeldClassIntrospector.serviceName(deploymentUnit), (Service)introspector).addDependency(BeanManagerService.serviceName(deploymentUnit), BeanManager.class, introspector.beanManager).install();
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(SERVICE_NAME);
    }

    public ManagedReferenceFactory createFactory(Class<?> clazz) {
        final BeanManager beanManager = (BeanManager)this.beanManager.getValue();
        final InjectionTarget injectionTarget = this.getInjectionTarget(clazz);
        return new ManagedReferenceFactory(){

            public ManagedReference getReference() {
                CreationalContext context = beanManager.createCreationalContext(null);
                Object instance = injectionTarget.produce(context);
                injectionTarget.inject(instance, context);
                injectionTarget.postConstruct(instance);
                return new WeldManagedReference(injectionTarget, context, instance);
            }
        };
    }

    private InjectionTarget getInjectionTarget(Class<?> clazz) {
        WeldInjectionTarget newTarget;
        InjectionTarget target = (InjectionTarget)this.injectionTargets.get(clazz);
        if (target != null) {
            return target;
        }
        BeanManagerImpl beanManager = BeanManagerProxy.unwrap((BeanManager)((BeanManager)this.beanManager.getValue()));
        Bean bean = null;
        HashSet beans = new HashSet(beanManager.getBeans(clazz, new Annotation[]{AnyLiteral.INSTANCE}));
        Iterator it = beans.iterator();
        while (it.hasNext()) {
            Bean b = (Bean)it.next();
            if (b.getBeanClass() == clazz) continue;
            it.remove();
        }
        if (beans.size() == 1) {
            bean = (Bean)beans.iterator().next();
        }
        if ((target = (InjectionTarget)this.injectionTargets.putIfAbsent(clazz, (InjectionTarget<?>)(newTarget = InjectionTargets.createInjectionTarget(clazz, bean, beanManager, true)))) == null) {
            return newTarget;
        }
        return target;
    }

    public ManagedReference createInstance(Object instance) {
        BeanManager beanManager = (BeanManager)this.beanManager.getValue();
        InjectionTarget injectionTarget = this.getInjectionTarget(instance.getClass());
        CreationalContext context = beanManager.createCreationalContext(null);
        injectionTarget.inject(instance, context);
        injectionTarget.postConstruct(instance);
        return new WeldManagedReference(injectionTarget, context, instance);
    }

    public InjectedValue<BeanManager> getBeanManager() {
        return this.beanManager;
    }

    public void start(StartContext startContext) throws StartException {
    }

    public void stop(StopContext stopContext) {
        this.injectionTargets.clear();
    }

    public EEClassIntrospector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static class WeldManagedReference
    implements ManagedReference {
        private final InjectionTarget injectionTarget;
        private final CreationalContext ctx;
        private final Object instance;

        public WeldManagedReference(InjectionTarget injectionTarget, CreationalContext ctx, Object instance) {
            this.injectionTarget = injectionTarget;
            this.ctx = ctx;
            this.instance = instance;
        }

        public void release() {
            try {
                this.injectionTarget.preDestroy(this.instance);
            }
            finally {
                this.ctx.release();
            }
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

