/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.core.DeploymentException;

public class DeploymentResult {
    static final DeploymentResult SUCCESSFUL = new DeploymentResult();
    private final boolean successful;
    private final String failureMessage;
    private final ModelNode result;

    private DeploymentResult() {
        this.successful = true;
        this.failureMessage = null;
        this.result = new ModelNode();
        this.result.protect();
    }

    DeploymentResult(ModelNode result) {
        this.successful = Operations.isSuccessfulOutcome((ModelNode)result);
        this.failureMessage = this.successful ? null : Operations.getFailureDescription((ModelNode)result).asString();
        this.result = result.clone();
        this.result.protect();
    }

    DeploymentResult(CharSequence failureMessage) {
        this.successful = false;
        this.failureMessage = failureMessage.toString();
        this.result = new ModelNode();
        this.result.protect();
    }

    DeploymentResult(String format, Object ... args) {
        this(String.format(format, args));
    }

    public boolean successful() {
        return this.successful;
    }

    public void assertSuccess() throws DeploymentException {
        if (!this.successful) {
            throw new DeploymentException(this.failureMessage);
        }
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public ModelNode asModelNode() {
        return this.result;
    }
}

