/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.hardware.common.AbstractSensors;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSensors
extends AbstractSensors {
    private static final long serialVersionUID = 1L;
    private String tempIdentifierStr = null;
    private String wmiTempNamespace = null;
    private String wmiTempClass = null;
    private String wmiTempProperty = null;
    private boolean fanSpeedWMI = true;
    private String voltIdentifierStr = null;
    private String wmiVoltNamespace = null;
    private String wmiVoltClass = null;
    private String wmiVoltProperty = null;

    @Override
    public double getCpuTemperature() {
        double tempC = 0.0;
        if (this.tempIdentifierStr != null) {
            Map<String, List<Float>> vals = WmiUtil.selectFloatsFrom("root\\OpenHardwareMonitor", "Sensor", "Value", "WHERE Parent=\"" + this.tempIdentifierStr + "\" AND SensorType=\"Temperature\"");
            if (vals.get("Value").size() > 0) {
                double sum = 0.0;
                Iterator<Float> iterator = vals.get("Value").iterator();
                while (iterator.hasNext()) {
                    double val = iterator.next().floatValue();
                    sum += val;
                }
                tempC = sum / (double)vals.get("Value").size();
            }
            return tempC;
        }
        long tempK = 0L;
        if (this.wmiTempClass == null) {
            this.wmiTempNamespace = "root\\cimv2";
            this.wmiTempClass = "Win32_Temperature";
            this.wmiTempProperty = "CurrentReading";
            tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            if (tempK == 0L) {
                this.wmiTempClass = "Win32_TemperatureProbe";
                tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            }
            if (tempK == 0L) {
                this.wmiTempClass = "Win32_PerfFormattedData_Counters_ThermalZoneInformation";
                this.wmiTempProperty = "Temperature";
                tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            }
            if (tempK == 0L) {
                this.wmiTempNamespace = "root\\wmi";
                this.wmiTempClass = "MSAcpi_ThermalZoneTemperature";
                this.wmiTempProperty = "CurrentTemperature";
                tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
            }
        } else {
            tempK = WmiUtil.selectUint32From(this.wmiTempNamespace, this.wmiTempClass, this.wmiTempProperty, null);
        }
        if (tempK > 0L) {
            tempC = (double)tempK / 10.0 - 273.15;
        }
        if (tempC <= 0.0) {
            String cpuIdentifier = WmiUtil.selectStringFrom("root\\OpenHardwareMonitor", "Hardware", "Identifier", "WHERE HardwareType=\"CPU\"");
            String string = this.tempIdentifierStr = cpuIdentifier.length() > 0 ? cpuIdentifier : null;
            if (this.tempIdentifierStr != null) {
                return this.getCpuTemperature();
            }
        }
        return tempC;
    }

    @Override
    public int[] getFanSpeeds() {
        int[] fanSpeeds = new int[1];
        if (!this.fanSpeedWMI) {
            Map<String, List<Float>> vals = WmiUtil.selectFloatsFrom("root\\OpenHardwareMonitor", "Sensor", "Value", "WHERE Parent=\"" + this.tempIdentifierStr + "\" AND SensorType=\"Fan\"");
            if (vals.get("Value").size() > 0) {
                fanSpeeds = new int[vals.get("Value").size()];
                for (int i = 0; i < vals.get("Value").size(); ++i) {
                    fanSpeeds[i] = vals.get("Value").get(i).intValue();
                }
            }
            return fanSpeeds;
        }
        int rpm = WmiUtil.selectUint32From(null, "Win32_Fan", "DesiredSpeed", null).intValue();
        if (rpm <= 0) {
            this.fanSpeedWMI = false;
            return this.getFanSpeeds();
        }
        fanSpeeds[0] = rpm;
        return fanSpeeds;
    }

    @Override
    public double getCpuVoltage() {
        double volts = 0.0;
        if (this.voltIdentifierStr != null) {
            return WmiUtil.selectFloatFrom("root\\OpenHardwareMonitor", "Sensor", "Value", "WHERE Parent=\"" + this.voltIdentifierStr + "\" AND SensorType=\"Voltage\"").floatValue();
        }
        int decivolts = 0;
        if (this.wmiVoltClass == null) {
            this.wmiVoltNamespace = "root\\cimv2";
            this.wmiVoltClass = "Win32_Processor";
            this.wmiVoltProperty = "CurrentVoltage";
            decivolts = WmiUtil.selectUint32From(this.wmiVoltNamespace, this.wmiVoltClass, this.wmiVoltProperty, null).intValue();
            if ((decivolts & 0x80) == 0 && decivolts > 0) {
                this.wmiVoltProperty = "VoltageCaps";
                decivolts = WmiUtil.selectUint32From(this.wmiVoltNamespace, this.wmiVoltClass, this.wmiVoltProperty, null).intValue();
            }
        } else {
            decivolts = WmiUtil.selectUint32From(this.wmiVoltNamespace, this.wmiVoltClass, this.wmiVoltProperty, null).intValue();
        }
        if (decivolts > 0) {
            if (this.wmiVoltProperty.equals("VoltageCaps")) {
                if ((decivolts & 1) > 0) {
                    volts = 5.0;
                } else if ((decivolts & 2) > 0) {
                    volts = 3.3;
                } else if ((decivolts & 4) > 0) {
                    volts = 2.9;
                }
            } else {
                volts = (double)(decivolts & 0x7F) / 10.0;
            }
        }
        if (volts <= 0.0) {
            Map<String, List<String>> voltIdentifiers = WmiUtil.selectStringsFrom("root\\OpenHardwareMonitor", "Hardware", "Identifier", "WHERE SensorType=\"Voltage\"");
            for (String id : voltIdentifiers.get("Identifier")) {
                if (!id.toLowerCase().contains("cpu")) continue;
                this.voltIdentifierStr = id;
                break;
            }
            if (this.voltIdentifierStr == null && voltIdentifiers.get("Identifier").size() > 0) {
                this.voltIdentifierStr = voltIdentifiers.get("Identifier").get(0);
            }
            if (this.voltIdentifierStr != null) {
                return this.getCpuVoltage();
            }
        }
        return volts;
    }
}

