/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.agent.monitor.storage.InventoryStringDataPoint;
import org.hawkular.agent.monitor.storage.MetricDefinition;
import org.hawkular.agent.monitor.util.Util;

class InventoryMetric {
    static final int DATA_RETENTION = 7;
    private final String feed;
    private final String type;
    private final String id;
    private final Set<String> resourceTypes;
    private final Set<String> metricTypes;

    private InventoryMetric(String feed, String type, String id, Set<String> resourceTypes, Set<String> metricTypes) {
        this.feed = feed;
        this.type = type;
        this.id = id;
        this.resourceTypes = resourceTypes;
        this.metricTypes = metricTypes;
    }

    static InventoryMetric resource(String feed, String id, Set<String> resourceTypes, Set<String> metricTypes) {
        return new InventoryMetric(feed, "r", id, resourceTypes, metricTypes);
    }

    static InventoryMetric resourceType(String feed, String id) {
        return new InventoryMetric(feed, "rt", id, null, null);
    }

    static InventoryMetric metricType(String feed, String id) {
        return new InventoryMetric(feed, "mt", id, null, null);
    }

    String getFeed() {
        return this.feed;
    }

    String getType() {
        return this.type;
    }

    String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryMetric that = (InventoryMetric)o;
        if (this.feed != null ? !this.feed.equals(that.feed) : that.feed != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.feed != null ? this.feed.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return "inventory." + this.feed + "." + this.type + "." + this.id;
    }

    public String encodedName() {
        return Util.urlEncode(this.name());
    }

    public WithData full(byte[] data) {
        return new WithData(this.feed, this.type, this.id, this.resourceTypes, this.metricTypes, Collections.singletonList(InventoryStringDataPoint.create(System.currentTimeMillis(), data)));
    }

    public WithData chunks(List<byte[]> chunks, int totalSize) {
        ArrayList<InventoryStringDataPoint> data = new ArrayList<InventoryStringDataPoint>(chunks.size());
        long timestamp = System.currentTimeMillis();
        for (byte[] chunk : chunks) {
            data.add(InventoryStringDataPoint.create(timestamp, chunk));
            --timestamp;
        }
        ((InventoryStringDataPoint)data.get(0)).setMasterInfo(chunks.size(), totalSize);
        return new WithData(this.feed, this.type, this.id, this.resourceTypes, this.metricTypes, data);
    }

    public MetricDefinition toMetricDefinition() {
        MetricDefinition def = new MetricDefinition(this.name(), 7);
        def.addTag("module", "inventory");
        def.addTag("feed", this.feed);
        def.addTag("type", this.type);
        def.addTag("id", this.id);
        if (this.resourceTypes != null) {
            def.addTag("restypes", "|" + this.resourceTypes.stream().collect(Collectors.joining("|")) + "|");
        }
        if (this.metricTypes != null) {
            def.addTag("mtypes", "|" + this.metricTypes.stream().collect(Collectors.joining("|")) + "|");
        }
        return def;
    }

    static class WithData
    extends InventoryMetric {
        private List<InventoryStringDataPoint> data;

        private WithData(String feed, String type, String id, Set<String> resourceTypes, Set<String> metricTypes, List<InventoryStringDataPoint> data) {
            super(feed, type, id, resourceTypes, metricTypes);
            this.data = data;
        }

        @Override
        public MetricDefinition toMetricDefinition() {
            MetricDefinition def = super.toMetricDefinition();
            if (!this.data.isEmpty()) {
                this.data.get(0).getNbChunks().ifPresent(n -> def.addTag("chunks", (String)n));
            }
            return def;
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public String getPayload() {
            return Util.toJson(this.data);
        }
    }
}

