/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.core.Assertions;

public class ServerProcess
extends Process {
    public static final OutputStream DISCARDING = new OutputStream(){

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    };
    private final Process delegate;
    private final Thread consoleConsumer;
    private final boolean inherited;

    private ServerProcess(Process delegate, Thread consoleConsumer) {
        this.delegate = delegate;
        this.consoleConsumer = consoleConsumer;
        this.inherited = consoleConsumer == null;
    }

    public static ServerProcess start(CommandBuilder commandBuilder) throws IOException {
        return ServerProcess.start(commandBuilder, null, null);
    }

    public static ServerProcess start(CommandBuilder commandBuilder, Map<String, String> env) throws IOException {
        return ServerProcess.start(commandBuilder, env, null);
    }

    public static ServerProcess start(CommandBuilder commandBuilder, Map<String, String> env, OutputStream stdout) throws IOException {
        Launcher launcher = Launcher.of((CommandBuilder)Assertions.requiresNotNullParameter(commandBuilder, "commandBuilder"));
        if (env != null) {
            launcher.addEnvironmentVariables(env);
        }
        if (stdout == null) {
            launcher.inherit();
        } else {
            launcher.setRedirectErrorStream(true);
        }
        Thread consoleConsumer = null;
        Process process = launcher.launch();
        if (stdout != null) {
            consoleConsumer = ServerProcess.consumeOutput(process, stdout);
        }
        return new ServerProcess(process, consoleConsumer);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.delegate.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.delegate.waitFor();
    }

    @Override
    public int exitValue() {
        return this.delegate.exitValue();
    }

    @Override
    public void destroy() {
        this.delegate.destroy();
    }

    public Thread getConsoleConsumer() {
        return this.consoleConsumer;
    }

    public boolean isInheritedStreams() {
        return this.inherited;
    }

    private static Thread consumeOutput(Process process, OutputStream stdout) {
        Thread thread = new Thread((Runnable)new ConsoleConsumer(process.getInputStream(), stdout), "WildFly-stdout");
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private static class ConsoleConsumer
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        ConsoleConsumer(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[64];
            try {
                int len;
                while ((len = this.in.read(buffer)) != -1) {
                    this.out.write(buffer, 0, len);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

