/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.SyncResolverImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSetInternal;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialStruct;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

public class CachedRowSetWriter
implements TransactionalWriter,
Serializable {
    private transient Connection con;
    private String selectCmd;
    private String updateCmd;
    private String updateWhere;
    private String deleteCmd;
    private String deleteWhere;
    private String insertCmd;
    private int[] keyCols;
    private Object[] params;
    private CachedRowSetReader reader;
    private ResultSetMetaData callerMd;
    private int callerColumnCount;
    private CachedRowSetImpl crsResolve;
    private ArrayList<Integer> status;
    private int iChangedValsInDbAndCRS;
    private int iChangedValsinDbOnly;
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = -8506030970299413976L;

    public CachedRowSetWriter() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean writeData(RowSetInternal caller) throws SQLException {
        long conflicts = 0L;
        boolean showDel = false;
        Statement pstmtIns = null;
        this.iChangedValsInDbAndCRS = 0;
        this.iChangedValsinDbOnly = 0;
        CachedRowSetImpl crs = (CachedRowSetImpl)caller;
        this.crsResolve = new CachedRowSetImpl();
        this.con = this.reader.connect(caller);
        if (this.con == null) {
            throw new SQLException(this.resBundle.handleGetObject("crswriter.connect").toString());
        }
        this.initSQLStatements(crs);
        RowSetMetaDataImpl rsmdWrite = (RowSetMetaDataImpl)crs.getMetaData();
        RowSetMetaDataImpl rsmdResolv = new RowSetMetaDataImpl();
        int iColCount = rsmdWrite.getColumnCount();
        int sz = crs.size() + 1;
        this.status = new ArrayList(sz);
        this.status.add(0, null);
        rsmdResolv.setColumnCount(iColCount);
        for (int i = 1; i <= iColCount; ++i) {
            rsmdResolv.setColumnType(i, rsmdWrite.getColumnType(i));
            rsmdResolv.setColumnName(i, rsmdWrite.getColumnName(i));
            rsmdResolv.setNullable(i, 2);
        }
        this.crsResolve.setMetaData(rsmdResolv);
        if (this.callerColumnCount < 1) {
            if (this.reader.getCloseConnection()) {
                this.con.close();
            }
            return true;
        }
        showDel = crs.getShowDeleted();
        crs.setShowDeleted(true);
        crs.beforeFirst();
        int rows = 1;
        while (crs.next()) {
            if (crs.rowDeleted()) {
                if (this.deleteOriginalRow(crs, this.crsResolve)) {
                    this.status.add(rows, 1);
                    ++conflicts;
                } else {
                    this.status.add(rows, 3);
                }
            } else if (crs.rowInserted()) {
                pstmtIns = this.con.prepareStatement(this.insertCmd);
                if (this.insertNewRow(crs, (PreparedStatement)pstmtIns, this.crsResolve)) {
                    this.status.add(rows, 2);
                    ++conflicts;
                } else {
                    this.status.add(rows, 3);
                }
            } else if (crs.rowUpdated()) {
                if (this.updateOriginalRow(crs)) {
                    this.status.add(rows, 0);
                    ++conflicts;
                } else {
                    this.status.add(rows, 3);
                }
            } else {
                int icolCount = crs.getMetaData().getColumnCount();
                this.status.add(rows, 3);
                this.crsResolve.moveToInsertRow();
                for (int cols = 0; cols < iColCount; ++cols) {
                    this.crsResolve.updateNull(cols + 1);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
            }
            ++rows;
        }
        if (pstmtIns != null) {
            pstmtIns.close();
        }
        crs.setShowDeleted(showDel);
        crs.beforeFirst();
        this.crsResolve.beforeFirst();
        if (conflicts != 0L) {
            SyncProviderException spe = new SyncProviderException(conflicts + " " + this.resBundle.handleGetObject("crswriter.conflictsno").toString());
            SyncResolverImpl syncResImpl = (SyncResolverImpl)spe.getSyncResolver();
            syncResImpl.setCachedRowSet(crs);
            syncResImpl.setCachedRowSetResolver(this.crsResolve);
            syncResImpl.setStatus(this.status);
            syncResImpl.setCachedRowSetWriter(this);
            throw spe;
        }
        return true;
    }

    private boolean updateOriginalRow(CachedRowSet crs) throws SQLException {
        int i = 0;
        int idx = 0;
        ResultSet origVals = crs.getOriginalRow();
        origVals.next();
        try {
            this.updateWhere = this.buildWhereClause(this.updateWhere, origVals);
            String tempselectCmd = this.selectCmd.toLowerCase();
            int idxWhere = tempselectCmd.indexOf("where");
            if (idxWhere != -1) {
                String tempSelect;
                this.selectCmd = tempSelect = this.selectCmd.substring(0, idxWhere);
            }
            PreparedStatement pstmt = this.con.prepareStatement(this.selectCmd + this.updateWhere, 1005, 1007);
            for (i = 0; i < this.keyCols.length; ++i) {
                if (this.params[i] == null) continue;
                pstmt.setObject(++idx, this.params[i]);
            }
            try {
                pstmt.setMaxRows(crs.getMaxRows());
                pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                pstmt.setQueryTimeout(crs.getQueryTimeout());
            }
            catch (Exception tempSelect) {
                // empty catch block
            }
            ResultSet rs = null;
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rs.next()) {
                if (rs.next()) {
                    return true;
                }
                rs.first();
                int colsNotChanged = 0;
                Vector<Integer> cols = new Vector<Integer>();
                String updateExec = this.updateCmd;
                boolean boolNull = true;
                Object objVal = null;
                boolean first = true;
                boolean flag = true;
                this.crsResolve.moveToInsertRow();
                for (i = 1; i <= this.callerColumnCount; ++i) {
                    Map<String, Class<?>> map;
                    Object orig = origVals.getObject(i);
                    Object curr = crs.getObject(i);
                    Object rsval = rs.getObject(i);
                    Map<String, Class<?>> map2 = map = crs.getTypeMap() == null ? this.con.getTypeMap() : crs.getTypeMap();
                    if (rsval instanceof Struct) {
                        Struct s = (Struct)rsval;
                        Class<?> c = null;
                        c = map.get(s.getSQLTypeName());
                        if (c != null) {
                            SQLData obj = null;
                            try {
                                obj = (SQLData)c.newInstance();
                            }
                            catch (InstantiationException ex) {
                                throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString(), ex.getMessage()));
                            }
                            catch (IllegalAccessException ex) {
                                throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString(), ex.getMessage()));
                            }
                            Object[] attribs = s.getAttributes(map);
                            SQLInputImpl sqlInput = new SQLInputImpl(attribs, map);
                            obj.readSQL(sqlInput, s.getSQLTypeName());
                            rsval = obj;
                        }
                    } else if (rsval instanceof SQLData) {
                        rsval = new SerialStruct((SQLData)rsval, map);
                    } else if (rsval instanceof Blob) {
                        rsval = new SerialBlob((Blob)rsval);
                    } else if (rsval instanceof Clob) {
                        rsval = new SerialClob((Clob)rsval);
                    } else if (rsval instanceof Array) {
                        rsval = new SerialArray((Array)rsval, map);
                    }
                    boolNull = true;
                    if (rsval == null && orig != null) {
                        ++this.iChangedValsinDbOnly;
                        boolNull = false;
                        objVal = rsval;
                    } else if (rsval != null && !rsval.equals(orig)) {
                        ++this.iChangedValsinDbOnly;
                        boolNull = false;
                        objVal = rsval;
                    } else if (orig == null || curr == null) {
                        if (!first || !flag) {
                            updateExec = updateExec + ", ";
                        }
                        updateExec = updateExec + crs.getMetaData().getColumnName(i);
                        cols.add(i);
                        updateExec = updateExec + " = ? ";
                        first = false;
                    } else if (orig.equals(curr)) {
                        ++colsNotChanged;
                    } else if (!orig.equals(curr) && crs.columnUpdated(i)) {
                        if (rsval.equals(orig)) {
                            if (!flag || !first) {
                                updateExec = updateExec + ", ";
                            }
                            updateExec = updateExec + crs.getMetaData().getColumnName(i);
                            cols.add(i);
                            updateExec = updateExec + " = ? ";
                            flag = false;
                        } else {
                            boolNull = false;
                            objVal = rsval;
                            ++this.iChangedValsInDbAndCRS;
                        }
                    }
                    if (!boolNull) {
                        this.crsResolve.updateObject(i, objVal);
                        continue;
                    }
                    this.crsResolve.updateNull(i);
                }
                rs.close();
                pstmt.close();
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
                if (!first && cols.size() == 0 || colsNotChanged == this.callerColumnCount) {
                    return false;
                }
                if (this.iChangedValsInDbAndCRS != 0 || this.iChangedValsinDbOnly != 0) {
                    return true;
                }
                updateExec = updateExec + this.updateWhere;
                pstmt = this.con.prepareStatement(updateExec);
                for (i = 0; i < cols.size(); ++i) {
                    Object obj = crs.getObject((Integer)cols.get(i));
                    if (obj != null) {
                        pstmt.setObject(i + 1, obj);
                        continue;
                    }
                    pstmt.setNull(i + 1, crs.getMetaData().getColumnType(i + 1));
                }
                idx = i;
                for (i = 0; i < this.keyCols.length; ++i) {
                    if (this.params[i] == null) continue;
                    pstmt.setObject(++idx, this.params[i]);
                }
                i = pstmt.executeUpdate();
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.crsResolve.moveToInsertRow();
            for (i = 1; i <= this.callerColumnCount; ++i) {
                this.crsResolve.updateNull(i);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean insertNewRow(CachedRowSet crs, PreparedStatement pstmt, CachedRowSetImpl crsRes) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean deleteOriginalRow(CachedRowSet crs, CachedRowSetImpl crsRes) throws SQLException {
        int i;
        int idx = 0;
        ResultSet origVals = crs.getOriginalRow();
        origVals.next();
        this.deleteWhere = this.buildWhereClause(this.deleteWhere, origVals);
        PreparedStatement pstmt = this.con.prepareStatement(this.selectCmd + this.deleteWhere, 1005, 1007);
        for (i = 0; i < this.keyCols.length; ++i) {
            if (this.params[i] == null) continue;
            pstmt.setObject(++idx, this.params[i]);
        }
        try {
            pstmt.setMaxRows(crs.getMaxRows());
            pstmt.setMaxFieldSize(crs.getMaxFieldSize());
            pstmt.setEscapeProcessing(crs.getEscapeProcessing());
            pstmt.setQueryTimeout(crs.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            if (rs.next()) {
                return true;
            }
            rs.first();
            boolean boolChanged = false;
            crsRes.moveToInsertRow();
            for (i = 1; i <= crs.getMetaData().getColumnCount(); ++i) {
                Object original = origVals.getObject(i);
                Object changed = rs.getObject(i);
                if (original != null && changed != null) {
                    if (original.toString().equals(changed.toString())) continue;
                    boolChanged = true;
                    crsRes.updateObject(i, origVals.getObject(i));
                    continue;
                }
                crsRes.updateNull(i);
            }
            crsRes.insertRow();
            crsRes.moveToCurrentRow();
            if (boolChanged) {
                return true;
            }
            String cmd = this.deleteCmd + this.deleteWhere;
            pstmt = this.con.prepareStatement(cmd);
            idx = 0;
            for (i = 0; i < this.keyCols.length; ++i) {
                if (this.params[i] == null) continue;
                pstmt.setObject(++idx, this.params[i]);
            }
            if (pstmt.executeUpdate() != 1) {
                return true;
            }
        } else {
            return true;
        }
        pstmt.close();
        return false;
    }

    public void setReader(CachedRowSetReader reader) throws SQLException {
        this.reader = reader;
    }

    public CachedRowSetReader getReader() throws SQLException {
        return this.reader;
    }

    private void initSQLStatements(CachedRowSet caller) throws SQLException {
        int i;
        this.callerMd = caller.getMetaData();
        this.callerColumnCount = this.callerMd.getColumnCount();
        if (this.callerColumnCount < 1) {
            return;
        }
        String table = caller.getTableName();
        if (table == null && ((table = this.callerMd.getTableName(1)) == null || table.length() == 0)) {
            throw new SQLException(this.resBundle.handleGetObject("crswriter.tname").toString());
        }
        String catalog = this.callerMd.getCatalogName(1);
        String schema = this.callerMd.getSchemaName(1);
        DatabaseMetaData dbmd = this.con.getMetaData();
        this.selectCmd = "SELECT ";
        for (i = 1; i <= this.callerColumnCount; ++i) {
            this.selectCmd = this.selectCmd + this.callerMd.getColumnName(i);
            this.selectCmd = i < this.callerMd.getColumnCount() ? this.selectCmd + ", " : this.selectCmd + " ";
        }
        this.selectCmd = this.selectCmd + "FROM " + this.buildTableName(dbmd, catalog, schema, table);
        this.updateCmd = "UPDATE " + this.buildTableName(dbmd, catalog, schema, table);
        String tempupdCmd = this.updateCmd.toLowerCase();
        int idxupWhere = tempupdCmd.indexOf("where");
        if (idxupWhere != -1) {
            this.updateCmd = this.updateCmd.substring(0, idxupWhere);
        }
        this.updateCmd = this.updateCmd + "SET ";
        this.insertCmd = "INSERT INTO " + this.buildTableName(dbmd, catalog, schema, table);
        this.insertCmd = this.insertCmd + "(";
        for (i = 1; i <= this.callerColumnCount; ++i) {
            this.insertCmd = this.insertCmd + this.callerMd.getColumnName(i);
            this.insertCmd = i < this.callerMd.getColumnCount() ? this.insertCmd + ", " : this.insertCmd + ") VALUES (";
        }
        for (i = 1; i <= this.callerColumnCount; ++i) {
            this.insertCmd = this.insertCmd + "?";
            this.insertCmd = i < this.callerColumnCount ? this.insertCmd + ", " : this.insertCmd + ")";
        }
        this.deleteCmd = "DELETE FROM " + this.buildTableName(dbmd, catalog, schema, table);
        this.buildKeyDesc(caller);
    }

    private String buildTableName(DatabaseMetaData dbmd, String catalog, String schema, String table) throws SQLException {
        String cmd = "";
        catalog = catalog.trim();
        schema = schema.trim();
        table = table.trim();
        if (dbmd.isCatalogAtStart()) {
            if (catalog != null && catalog.length() > 0) {
                cmd = cmd + catalog + dbmd.getCatalogSeparator();
            }
            if (schema != null && schema.length() > 0) {
                cmd = cmd + schema + ".";
            }
            cmd = cmd + table;
        } else {
            if (schema != null && schema.length() > 0) {
                cmd = cmd + schema + ".";
            }
            cmd = cmd + table;
            if (catalog != null && catalog.length() > 0) {
                cmd = cmd + dbmd.getCatalogSeparator() + catalog;
            }
        }
        cmd = cmd + " ";
        return cmd;
    }

    private void buildKeyDesc(CachedRowSet crs) throws SQLException {
        this.keyCols = crs.getKeyColumns();
        ResultSetMetaData resultsetmd = crs.getMetaData();
        if (this.keyCols == null || this.keyCols.length == 0) {
            int i;
            ArrayList<Integer> listKeys = new ArrayList<Integer>();
            for (i = 0; i < this.callerColumnCount; ++i) {
                if (resultsetmd.getColumnType(i + 1) == 2005 || resultsetmd.getColumnType(i + 1) == 2002 || resultsetmd.getColumnType(i + 1) == 2009 || resultsetmd.getColumnType(i + 1) == 2004 || resultsetmd.getColumnType(i + 1) == 2003 || resultsetmd.getColumnType(i + 1) == 1111) continue;
                listKeys.add(i + 1);
            }
            this.keyCols = new int[listKeys.size()];
            for (i = 0; i < listKeys.size(); ++i) {
                this.keyCols[i] = (Integer)listKeys.get(i);
            }
        }
        this.params = new Object[this.keyCols.length];
    }

    private String buildWhereClause(String whereClause, ResultSet rs) throws SQLException {
        whereClause = "WHERE ";
        for (int i = 0; i < this.keyCols.length; ++i) {
            if (i > 0) {
                whereClause = whereClause + "AND ";
            }
            whereClause = whereClause + this.callerMd.getColumnName(this.keyCols[i]);
            this.params[i] = rs.getObject(this.keyCols[i]);
            whereClause = rs.wasNull() ? whereClause + " IS NULL " : whereClause + " = ? ";
        }
        return whereClause;
    }

    void updateResolvedConflictToDB(CachedRowSet crs, Connection con) throws SQLException {
        int i;
        int i2;
        String strWhere = "WHERE ";
        String strExec = " ";
        String strUpdate = "UPDATE ";
        int icolCount = crs.getMetaData().getColumnCount();
        int[] keyColumns = crs.getKeyColumns();
        String strSet = "";
        strWhere = this.buildWhereClause(strWhere, crs);
        if (keyColumns == null || keyColumns.length == 0) {
            keyColumns = new int[icolCount];
            int i3 = 0;
            while (i3 < keyColumns.length) {
                keyColumns[i3++] = i3;
            }
        }
        Object[] param = new Object[keyColumns.length];
        strUpdate = "UPDATE " + this.buildTableName(con.getMetaData(), crs.getMetaData().getCatalogName(1), crs.getMetaData().getSchemaName(1), crs.getTableName());
        strUpdate = strUpdate + "SET ";
        boolean first = true;
        for (i2 = 1; i2 <= icolCount; ++i2) {
            if (!crs.columnUpdated(i2)) continue;
            if (!first) {
                strSet = strSet + ", ";
            }
            strSet = strSet + crs.getMetaData().getColumnName(i2);
            strSet = strSet + " = ? ";
            first = false;
        }
        strUpdate = strUpdate + strSet;
        strWhere = "WHERE ";
        for (i2 = 0; i2 < keyColumns.length; ++i2) {
            if (i2 > 0) {
                strWhere = strWhere + "AND ";
            }
            strWhere = strWhere + crs.getMetaData().getColumnName(keyColumns[i2]);
            param[i2] = crs.getObject(keyColumns[i2]);
            strWhere = crs.wasNull() ? strWhere + " IS NULL " : strWhere + " = ? ";
        }
        strUpdate = strUpdate + strWhere;
        PreparedStatement pStmt = con.prepareStatement(strUpdate);
        int idx = 0;
        for (i = 0; i < icolCount; ++i) {
            if (!crs.columnUpdated(i + 1)) continue;
            Object obj = crs.getObject(i + 1);
            if (obj != null) {
                pStmt.setObject(++idx, obj);
                continue;
            }
            pStmt.setNull(i + 1, crs.getMetaData().getColumnType(i + 1));
        }
        for (i = 0; i < keyColumns.length; ++i) {
            if (param[i] == null) continue;
            pStmt.setObject(++idx, param[i]);
        }
        int id = pStmt.executeUpdate();
    }

    @Override
    public void commit() throws SQLException {
        this.con.commit();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    public void commit(CachedRowSetImpl crs, boolean updateRowset) throws SQLException {
        this.con.commit();
        if (updateRowset && crs.getCommand() != null) {
            crs.execute(this.con);
        }
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.con.rollback();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    @Override
    public void rollback(Savepoint s) throws SQLException {
        this.con.rollback(s);
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean isPKNameValid(String pk, ResultSetMetaData rsmd) throws SQLException {
        boolean isValid = false;
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String colName = rsmd.getColumnClassName(i);
            if (!colName.equalsIgnoreCase(pk)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }
}

