/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.log;

import java.util.Collection;
import java.util.List;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKMONITOR")
@ValidIdRange(min=10000, max=19999)
public interface MsgLogger
extends BasicLogger {
    public static final MsgLogger LOG = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)"org.hawkular.agent.monitor");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10000, value="Starting Hawkular Agent")
    public void infoStarting();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10001, value="Stopping Hawkular Agent")
    public void infoStopping();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10002, value="Hawkular Agent is disabled - it will not be started")
    public void infoAgentDisabled();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10008, value="A metric collection failed")
    public void errorMetricCollectionFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10009, value="An availability check failed")
    public void errorAvailCheckFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10010, value="Failed to store metric data: %s")
    public void errorFailedToStoreMetricData(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10011, value="Failed to store avail data: %s")
    public void errorFailedToStoreAvailData(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10012, value="Starting scheduler")
    public void infoStartingScheduler();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10013, value="Stopping scheduler")
    public void infoStoppingScheduler();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10016, value="The resource type [%s] wants to use an unknown metric set [%s]")
    public void warnMetricSetDoesNotExist(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10017, value="The resource type [%s] wants to use an unknown avail set [%s]")
    public void warnAvailSetDoesNotExist(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10019, value="Managed server [%s] is disabled. It will not be monitored.")
    public void infoManagedServerDisabled(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10020, value="The managed server [%s] wants to use an unknown resource type set [%s]")
    public void warnResourceTypeSetDoesNotExist(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10022, value="Resource type [%s] is disabled - all if its child types will also be disabled: %s")
    public void infoDisablingResourceTypes(Object var1, List<?> var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10024, value="Failed to store inventory data")
    public void errorFailedToStoreInventoryData(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10028, value="Cannot start storage adapter; aborting startup")
    public void errorCannotStartStorageAdapter(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10029, value="Scheduler failed to initialize; aborting startup")
    public void errorCannotInitializeScheduler(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10030, value="Using keystore at [%s]")
    public void infoUseKeystore(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10032, value="Server provided an invalid command request: [%s]")
    public void errorInvalidCommandRequestFeed(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10033, value="Failed to execute command [%s] for server")
    public void errorCommandExecutionFailureFeed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10034, value="Opened feed WebSocket connection to endpoint [%s]")
    public void infoOpenedFeedComm(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10035, value="Closed feed WebSocket connection to endpoint [%s]. Code=[%d], Reason=[%s]")
    public void infoClosedFeedComm(String var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10036, value="Feed communications channel encountered a failure. Response=[%s]")
    public void warnFeedCommFailure(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10037, value="Failed to send message [%s] over the feed communications channel")
    public void errorFailedToSendOverFeedComm(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10038, value="Failed to close web socket with code=[%d] and reason=[%s]")
    public void warnFailedToCloseWebSocket(int var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10039, value="The command-gateway URL is [%s]")
    public void infoFeedCommUrl(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10040, value="Cannot re-establish websocket connection")
    public void errorCannotReconnectToWebSocket(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10041, value="Cannot close command-gateway websocket")
    public void errorCannotCloseWebSocketCall(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10042, value="Cannot connect to the server over the feed communications channel.")
    public void errorCannotEstablishFeedComm(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10043, value="Received the following error message and stack trace from server: %s\n%s")
    public void warnReceivedGenericErrorResponse(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10047, value="Failed to locate [%s] at location [%s] relative to [%s]")
    public void warnFailedToLocate(@Cause ProtocolException var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10049, value="Could not access resources of endpoint [%s]")
    public void errorCouldNotAccess(EndpointService<?, ?> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10051, value="Missing tenant ID")
    public void errorNoTenantIdSpecified();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10052, value="Could not store metrics for monitored endpoint [%s]")
    public void errorFailedToStoreMetrics(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10053, value="Could not store availability data for monitored endpoint [%s]")
    public void errorFailedToStoreAvails(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10054, value="Agent encountered errors during start up and will be stopped.")
    public void errorFailedToStartAgent(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10055, value="Agent encountered errors during shutdown")
    public void warnFailedToStopAgent(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10056, value="Periodic auto-discovery scans have been disabled")
    public void infoAutoDiscoveryDisabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10057, value="Auto-discovery scans will be performed every [%d] seconds")
    public void infoAutoDiscoveryEnabled(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10058, value="Auto-discovery scan failed")
    public void errorAutoDiscoveryFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10060, value="Could not close [%s]")
    public void errorCannotClose(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10061, value="Failed to discover resources in [%s]")
    public void errorFailedToDiscoverResources(@Cause Throwable var1, MonitoredEndpoint<?> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10065, value="Received request to perform [%s] on a [%s] given by inventory path [%s]")
    public void infoReceivedResourcePathCommand(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10066, value="Being asked to discover all resources for endpoint [%s]")
    public void infoDiscoveryRequested(MonitoredEndpoint<?> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10068, value="Agent is already stopped.")
    public void infoStoppedAlready();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10071, value="No longer monitoring the endpoint [%s]")
    public void infoRemovedEndpointService(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10073, value="Now monitoring the new endpoint [%s]")
    public void infoAddedEndpointService(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10074, value="The resource type [%s] is missing a parent. Make sure at least one of these resource types are defined and enabled: %s")
    public void errorInvalidRootResourceType(String var1, Collection<Name> var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10077, value="Failed to store metric tags: %s")
    public void errorFailedToStoreMetricTags(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10078, value="Tried %d times to reach the server %s endpoint at %s. Is it up?")
    public void warnConnectionDelayed(int var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10079, value="Agent being asked to start when it is already starting up. Will wait.")
    public void infoAlreadyStarting();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10081, value="Cannot get Hawkular Server status - does the agent have proper credentials? (%d/%s)")
    public void warnBadHawkularCredentials(int var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10082, value="Agent being asked to start but is currently stopping. Will wait and then restart.")
    public void infoAgentWillStartAfterStopping();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10083, value="Failed to store notification: %s")
    public void errorFailedToStoreNotification(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10084, value="%s version %s")
    public void infoTypeAndVersion(String var1, String var2);
}

