/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.service;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.HawkularAgentContext;
import org.hawkular.agent.monitor.api.HawkularAgentContextImpl;
import org.hawkular.agent.monitor.cmd.Command;
import org.hawkular.agent.monitor.cmd.FeedCommProcessor;
import org.hawkular.agent.monitor.cmd.WebSocketClientBuilder;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.diagnostics.DiagnosticsImpl;
import org.hawkular.agent.monitor.diagnostics.JBossLoggingReporter;
import org.hawkular.agent.monitor.diagnostics.StorageReporter;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.agent.monitor.scheduler.SchedulerConfiguration;
import org.hawkular.agent.monitor.scheduler.SchedulerService;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.AvailStorageProxy;
import org.hawkular.agent.monitor.storage.HawkularStorageAdapter;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.InventoryStorageProxy;
import org.hawkular.agent.monitor.storage.MetricStorageProxy;
import org.hawkular.agent.monitor.storage.NotificationDispatcher;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.bus.common.BasicMessage;
import org.jboss.logging.Logger;

public abstract class AgentCoreEngine {
    private static final MsgLogger log = AgentLoggers.getLogger(AgentCoreEngine.class);
    private AtomicReference<ServiceStatus> agentServiceStatus = new AtomicReference<ServiceStatus>(ServiceStatus.INITIAL);
    private AgentCoreEngineConfiguration configuration;
    private String feedId;
    private Diagnostics diagnostics;
    private ScheduledReporter diagnosticsReporter;
    private StorageAdapter storageAdapter;
    private HttpClientBuilder httpClientBuilder;
    private WebSocketClientBuilder webSocketClientBuilder;
    private FeedCommProcessor feedComm;
    private SchedulerService schedulerService;
    private NotificationDispatcher notificationDispatcher;
    private final MetricStorageProxy metricStorageProxy = new MetricStorageProxy();
    private final AvailStorageProxy availStorageProxy = new AvailStorageProxy();
    private final InventoryStorageProxy inventoryStorageProxy = new InventoryStorageProxy();
    private ProtocolServices protocolServices;
    private ModelControllerClientFactory localModelControllerClientFactory;
    private Map<String, SSLContext> trustOnlySSLContextValues;
    private Map<String, TrustManager[]> trustOnlyTrustManagersValues;

    public AgentCoreEngine(AgentCoreEngineConfiguration configuration) {
        this.configuration = configuration;
    }

    public AgentCoreEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    public HawkularAgentContext getHawkularAgentContext() {
        return new HawkularAgentContextImpl(this.metricStorageProxy, this.availStorageProxy, this.inventoryStorageProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceStatus getStatus() {
        AtomicReference<ServiceStatus> atomicReference = this.agentServiceStatus;
        synchronized (atomicReference) {
            return this.agentServiceStatus.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(ServiceStatus newStatus) {
        AtomicReference<ServiceStatus> atomicReference = this.agentServiceStatus;
        synchronized (atomicReference) {
            this.agentServiceStatus.set(newStatus);
            this.agentServiceStatus.notifyAll();
        }
    }

    public void startHawkularAgent() {
        this.startHawkularAgent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHawkularAgent(AgentCoreEngineConfiguration newConfiguration) {
        AtomicReference<ServiceStatus> atomicReference = this.agentServiceStatus;
        synchronized (atomicReference) {
            boolean processStatus = true;
            while (processStatus) {
                switch (this.agentServiceStatus.get()) {
                    case RUNNING: {
                        return;
                    }
                    case STARTING: {
                        log.infoAlreadyStarting();
                        while (this.agentServiceStatus.get() != ServiceStatus.RUNNING && this.agentServiceStatus.get() != ServiceStatus.STOPPED) {
                            try {
                                this.agentServiceStatus.wait(30000L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        return;
                    }
                    case STOPPING: {
                        log.infoAgentWillStartAfterStopping();
                        while (this.agentServiceStatus.get() == ServiceStatus.STOPPING) {
                            try {
                                this.agentServiceStatus.wait(30000L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        processStatus = true;
                        break;
                    }
                    case STOPPED: 
                    case INITIAL: {
                        processStatus = false;
                    }
                }
            }
            this.setStatus(ServiceStatus.STARTING);
        }
        try {
            Package agentPackage = this.getClass().getPackage();
            if (agentPackage != null) {
                log.infoTypeAndVersion(agentPackage.getImplementationTitle(), agentPackage.getImplementationVersion());
            }
            log.infoStarting();
            if (null != newConfiguration) {
                this.configuration = newConfiguration;
            }
            this.configuration = this.loadRuntimeConfiguration(this.configuration);
            if (!this.configuration.getGlobalConfiguration().isSubsystemEnabled()) {
                log.infoAgentDisabled();
                this.setStatus(ServiceStatus.STOPPED);
                return;
            }
            if (this.configuration.getStorageAdapter().getTenantId() == null) {
                log.errorNoTenantIdSpecified();
                throw new Exception("Missing tenant ID");
            }
            this.trustOnlySSLContextValues = this.buildTrustOnlySSLContextValues(this.configuration);
            this.trustOnlyTrustManagersValues = this.buildTrustOnlyTrustManagersValues(this.configuration);
            SSLContext ssl = null;
            X509TrustManager x509TrustManager = null;
            String securityRealm = this.configuration.getStorageAdapter().getSecurityRealm();
            if (securityRealm != null) {
                ssl = this.trustOnlySSLContextValues.get(securityRealm);
                TrustManager[] tms = this.trustOnlyTrustManagersValues.get(securityRealm);
                if (tms != null) {
                    for (TrustManager tm : tms) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        x509TrustManager = (X509TrustManager)tm;
                    }
                }
            }
            this.httpClientBuilder = new HttpClientBuilder(this.configuration.getStorageAdapter(), ssl, x509TrustManager);
            this.localModelControllerClientFactory = this.buildLocalModelControllerClientFactory();
            this.feedId = this.configuration.getStorageAdapter().getFeedId() != null ? this.configuration.getStorageAdapter().getFeedId() : this.autoGenerateFeedId();
            MetricRegistry metricRegistry = new MetricRegistry();
            this.diagnostics = new DiagnosticsImpl(this.configuration.getDiagnostics(), metricRegistry, this.feedId);
            Set<String> tenantIds = this.getTenantIds();
            this.waitForHawkularServer();
            switch (this.configuration.getStorageAdapter().getType()) {
                case HAWKULAR: {
                    try {
                        this.webSocketClientBuilder = new WebSocketClientBuilder(this.configuration.getStorageAdapter(), ssl, x509TrustManager);
                        this.feedComm = new FeedCommProcessor(this.webSocketClientBuilder, this.buildAdditionalCommands(), this.feedId, this);
                        this.feedComm.connect();
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        log.errorCannotEstablishFeedComm(e);
                    }
                    break;
                }
                case METRICS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown storage adapter type: " + (Object)((Object)this.configuration.getStorageAdapter().getType()));
                }
            }
            try {
                this.startStorageAdapter();
            }
            catch (Exception e) {
                log.errorCannotStartStorageAdapter(e);
                throw new Exception("Agent cannot start storage adapter");
            }
            try {
                this.startScheduler(tenantIds);
            }
            catch (Exception e) {
                log.errorCannotInitializeScheduler(e);
                throw new Exception("Agent cannot initialize scheduler");
            }
            this.notificationDispatcher = this.configuration.getStorageAdapter().getType() == AgentCoreEngineConfiguration.StorageReportTo.HAWKULAR ? new NotificationDispatcher(this.storageAdapter, this.feedId) : null;
            ProtocolServices ps = this.createProtocolServicesBuilder().dmrProtocolService(this.localModelControllerClientFactory, this.configuration.getDmrConfiguration()).jmxProtocolService(this.configuration.getJmxConfiguration()).platformProtocolService(this.configuration.getPlatformConfiguration()).autoDiscoveryScanPeriodSecs(this.configuration.getGlobalConfiguration().getAutoDiscoveryScanPeriodSeconds()).build();
            ps.addInventoryListener(this.inventoryStorageProxy);
            ps.addInventoryListener(this.schedulerService);
            if (this.notificationDispatcher != null) {
                ps.addInventoryListener(this.notificationDispatcher);
            }
            this.protocolServices = ps;
            this.protocolServices.start();
            this.setStatus(ServiceStatus.RUNNING);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.errorFailedToStartAgent(t);
            this.stopHawkularAgent();
        }
    }

    private Set<String> getTenantIds() {
        HashSet<String> tenantIds = new HashSet<String>();
        ArrayList<AgentCoreEngineConfiguration.EndpointConfiguration> endpoints = new ArrayList<AgentCoreEngineConfiguration.EndpointConfiguration>();
        endpoints.addAll(this.configuration.getDmrConfiguration().getEndpoints().values());
        endpoints.addAll(this.configuration.getJmxConfiguration().getEndpoints().values());
        endpoints.addAll(this.configuration.getPlatformConfiguration().getEndpoints().values());
        tenantIds.add(this.configuration.getStorageAdapter().getTenantId());
        for (AgentCoreEngineConfiguration.AbstractEndpointConfiguration abstractEndpointConfiguration : endpoints) {
            String tenantId = abstractEndpointConfiguration.getTenantId();
            if (tenantId == null) continue;
            tenantIds.add(tenantId);
        }
        return tenantIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHawkularAgent() {
        AtomicReference<ServiceStatus> atomicReference = this.agentServiceStatus;
        synchronized (atomicReference) {
            if (this.agentServiceStatus.get() == ServiceStatus.STOPPED) {
                log.infoStoppedAlready();
                return;
            }
            if (this.agentServiceStatus.get() == ServiceStatus.STOPPING && this.agentServiceStatus.get() == ServiceStatus.STOPPING) {
                try {
                    this.agentServiceStatus.wait(30000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                return;
            }
            this.setStatus(ServiceStatus.STOPPING);
        }
        log.infoStopping();
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        try {
            try {
                if (this.feedComm != null) {
                    this.feedComm.destroy();
                    this.feedComm = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown feed comm but will continue shutdown", t);
            }
            Map<EndpointService<?, ?>, List<MeasurementInstance<?, AvailType<?>>>> availsToChange = null;
            try {
                if (this.protocolServices != null) {
                    availsToChange = this.getAvailsToChange();
                    this.protocolServices.stop();
                    this.protocolServices.removeInventoryListener(this.inventoryStorageProxy);
                    this.protocolServices.removeInventoryListener(this.schedulerService);
                    if (this.notificationDispatcher != null) {
                        this.protocolServices.removeInventoryListener(this.notificationDispatcher);
                    }
                    this.protocolServices = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown protocol services but will continue shutdown", t);
            }
            try {
                if (this.schedulerService != null) {
                    this.schedulerService.stop();
                    this.schedulerService = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown scheduler but will continue shutdown", t);
            }
            try {
                if (this.storageAdapter != null) {
                    this.changeAvails(availsToChange);
                    this.storageAdapter.shutdown();
                    this.storageAdapter = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown storage adapter but will continue shutdown", t);
            }
            if (this.diagnosticsReporter != null) {
                this.diagnosticsReporter.stop();
                if (this.configuration.getDiagnostics().isEnabled()) {
                    this.diagnosticsReporter.report();
                }
                this.diagnosticsReporter = null;
            }
            try {
                this.cleanupDuringStop();
            }
            catch (Exception e) {
                error.compareAndSet(null, e);
                log.debug("Cannot shutdown - subclass exception", e);
            }
            if (error.get() != null) {
                throw (Throwable)error.get();
            }
        }
        catch (Throwable t) {
            log.warnFailedToStopAgent(t);
        }
        finally {
            this.setStatus(ServiceStatus.STOPPED);
        }
    }

    private void changeAvails(Map<EndpointService<?, ?>, List<MeasurementInstance<?, AvailType<?>>>> availsToChange) {
        if (availsToChange != null && !availsToChange.isEmpty() && this.storageAdapter != null) {
            long now = System.currentTimeMillis();
            HashSet<AvailDataPoint> datapoints = new HashSet<AvailDataPoint>();
            for (EndpointService<?, ?> endpointService : availsToChange.keySet()) {
                AgentCoreEngineConfiguration.EndpointConfiguration config = endpointService.getMonitoredEndpoint().getEndpointConfiguration();
                Avail setAvailOnShutdown = config.getSetAvailOnShutdown();
                if (setAvailOnShutdown == null) continue;
                List<MeasurementInstance<?, AvailType<?>>> avails = availsToChange.get(endpointService);
                for (MeasurementInstance<?, AvailType<?>> avail : avails) {
                    AvailDataPoint availDataPoint = new AvailDataPoint(avail.getAssociatedMetricId(), now, setAvailOnShutdown, config.getTenantId());
                    datapoints.add(availDataPoint);
                }
            }
            this.storageAdapter.storeAvails(datapoints, 60000L);
        }
    }

    private Map<EndpointService<?, ?>, List<MeasurementInstance<?, AvailType<?>>>> getAvailsToChange() {
        HashMap avails = new HashMap();
        for (ProtocolService<?, ?> protocolService : this.protocolServices.getServices()) {
            for (EndpointService<?, ?> endpointService : protocolService.getEndpointServices().values()) {
                ResourceManager<?> rm;
                AgentCoreEngineConfiguration.EndpointConfiguration config = endpointService.getMonitoredEndpoint().getEndpointConfiguration();
                Avail setAvailOnShutdown = config.getSetAvailOnShutdown();
                if (setAvailOnShutdown == null || (rm = endpointService.getResourceManager()).getRootResources().isEmpty()) continue;
                ArrayList esAvails = new ArrayList();
                avails.put(endpointService, esAvails);
                List<Resource<?>> resources = rm.getResourcesBreadthFirst();
                for (Resource<?> resource : resources) {
                    Collection<MeasurementInstance<?, AvailType<?>>> resourceAvails = resource.getAvails();
                    esAvails.addAll(resourceAvails);
                }
            }
        }
        return avails;
    }

    private void startStorageAdapter() throws Exception {
        this.storageAdapter = new HawkularStorageAdapter();
        this.storageAdapter.initialize(this.feedId, this.configuration.getStorageAdapter(), this.configuration.getGlobalConfiguration().getAutoDiscoveryScanPeriodSeconds(), this.diagnostics, this.httpClientBuilder);
        this.metricStorageProxy.setStorageAdapter(this.storageAdapter);
        this.availStorageProxy.setStorageAdapter(this.storageAdapter);
        this.inventoryStorageProxy.setStorageAdapter(this.storageAdapter);
        switch (this.configuration.getDiagnostics().getReportTo()) {
            case LOG: {
                this.diagnosticsReporter = JBossLoggingReporter.forRegistry(this.diagnostics.getMetricRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(Logger.getLogger(this.getClass())).withLoggingLevel(JBossLoggingReporter.LoggingLevel.DEBUG).build();
                break;
            }
            case STORAGE: {
                this.diagnosticsReporter = StorageReporter.forRegistry(this.diagnostics.getMetricRegistry(), this.configuration.getDiagnostics(), this.storageAdapter).feedId(this.feedId).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                break;
            }
            default: {
                throw new Exception("Invalid diagnostics type: " + (Object)((Object)this.configuration.getDiagnostics().getReportTo()));
            }
        }
        if (this.configuration.getDiagnostics().isEnabled()) {
            this.diagnosticsReporter.start((long)this.configuration.getDiagnostics().getInterval(), this.configuration.getDiagnostics().getTimeUnits());
        }
    }

    private void startScheduler(Set<String> tenantIds) throws Exception {
        if (this.schedulerService == null) {
            SchedulerConfiguration schedulerConfig = new SchedulerConfiguration();
            schedulerConfig.setDiagnosticsConfig(this.configuration.getDiagnostics());
            schedulerConfig.setStorageAdapterConfig(this.configuration.getStorageAdapter());
            schedulerConfig.setMetricDispatcherBufferSize(this.configuration.getGlobalConfiguration().getMetricDispatcherBufferSize());
            schedulerConfig.setMetricDispatcherMaxBatchSize(this.configuration.getGlobalConfiguration().getMetricDispatcherMaxBatchSize());
            schedulerConfig.setAvailDispatcherBufferSize(this.configuration.getGlobalConfiguration().getAvailDispatcherBufferSize());
            schedulerConfig.setAvailDispatcherMaxBatchSize(this.configuration.getGlobalConfiguration().getAvailDispatcherMaxBatchSize());
            schedulerConfig.setPingDispatcherPeriodSeconds(this.configuration.getGlobalConfiguration().getPingDispatcherPeriodSeconds());
            schedulerConfig.setFeedId(this.feedId);
            schedulerConfig.setTenantIds(tenantIds);
            this.schedulerService = new SchedulerService(schedulerConfig, this.diagnostics, this.storageAdapter);
        }
        this.schedulerService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForHawkularServer() throws Exception {
        OkHttpClient httpclient = this.httpClientBuilder.getHttpClient();
        String statusUrl = Util.getContextUrlString(this.configuration.getStorageAdapter().getUrl(), this.configuration.getStorageAdapter().getMetricsContext()).append("status").toString();
        Request request = this.httpClientBuilder.buildJsonGetRequest(statusUrl, null);
        int counter = 0;
        while (true) {
            Response response = null;
            try {
                response = httpclient.newCall(request).execute();
                if (response.code() != 200) {
                    if (response.code() != 401) {
                        log.debugf("Hawkular Metrics is not ready yet: %d/%s", response.code(), response.message());
                    } else {
                        log.warnBadHawkularCredentials(response.code(), response.message());
                    }
                } else {
                    String bodyString = response.body().string();
                    if (this.checkReallyUp(bodyString)) {
                        log.debugf("Hawkular Metrics is ready: %s", bodyString);
                        break;
                    }
                    log.debugf("Hawkular Metrics is still starting: %s", bodyString);
                }
            }
            catch (Exception e) {
                log.debugf("Hawkular Metrics is not ready yet: %s", e.toString());
            }
            finally {
                if (response != null) {
                    response.body().close();
                }
            }
            Thread.sleep(5000L);
            if (++counter % 12 != 0) continue;
            log.warnConnectionDelayed(counter, "metrics", statusUrl);
        }
    }

    private boolean checkReallyUp(String bodyString) {
        ObjectMapper mapper = new ObjectMapper();
        Map result = null;
        try {
            result = (Map)mapper.readValue(bodyString, Map.class);
        }
        catch (IOException e) {
            return false;
        }
        String status = (String)result.get("MetricsService");
        return "STARTED".equals(status);
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getTenantId() {
        return this.configuration.getStorageAdapter().getTenantId();
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public ModelControllerClientFactory getLocalModelControllerClientFactory() {
        return this.localModelControllerClientFactory;
    }

    public ProtocolServices.Builder createProtocolServicesBuilder() {
        return ProtocolServices.builder(this.feedId, this.diagnostics, this.trustOnlySSLContextValues);
    }

    public ProtocolServices getProtocolServices() {
        return this.protocolServices;
    }

    public boolean isImmutable() {
        return this.configuration.getGlobalConfiguration().isImmutable();
    }

    protected abstract Map<String, SSLContext> buildTrustOnlySSLContextValues(AgentCoreEngineConfiguration var1);

    protected abstract Map<String, TrustManager[]> buildTrustOnlyTrustManagersValues(AgentCoreEngineConfiguration var1);

    protected abstract ModelControllerClientFactory buildLocalModelControllerClientFactory();

    protected abstract AgentCoreEngineConfiguration loadRuntimeConfiguration(AgentCoreEngineConfiguration var1);

    protected abstract void cleanupDuringStop();

    protected abstract String autoGenerateFeedId() throws Exception;

    protected abstract Map<String, Class<? extends Command<? extends BasicMessage, ? extends BasicMessage>>> buildAdditionalCommands();
}

