/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.aesh.cl.activation.OptionActivator;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.cl.converter.Converter;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.renderer.OptionRenderer;
import org.jboss.aesh.cl.validator.OptionValidator;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.converter.AeshConverterInvocation;
import org.jboss.aesh.console.command.validator.AeshValidatorInvocation;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.aesh.util.ANSI;

public final class ProcessedOption {
    private String shortName;
    private String name;
    private String description;
    private List<String> values;
    private String argument;
    private List<String> defaultValues;
    private Class<?> type;
    private Converter converter;
    private OptionType optionType;
    private boolean required = false;
    private char valueSeparator;
    private String fieldName;
    private OptionCompleter completer;
    private Map<String, String> properties;
    private boolean longNameUsed = true;
    private OptionValidator validator;
    private boolean endsWithSeparator = false;
    private OptionActivator activator;
    private OptionRenderer renderer;
    private boolean overrideRequired = false;
    private boolean ansiMode = true;

    public ProcessedOption(char shortName, String name, String description, String argument, boolean required, char valueSeparator, List<String> defaultValue, Class<?> type, String fieldName, OptionType optionType, Converter converter, OptionCompleter completer, OptionValidator optionValidator, OptionActivator activator, OptionRenderer renderer, boolean overrideRequired) throws OptionParserException {
        if (shortName != '\u0000') {
            this.shortName = String.valueOf(shortName);
        }
        this.name = name;
        this.description = description;
        this.argument = argument;
        this.required = required;
        this.valueSeparator = valueSeparator;
        this.type = type;
        this.fieldName = fieldName;
        this.overrideRequired = overrideRequired;
        this.optionType = optionType;
        this.converter = converter;
        this.completer = completer;
        this.validator = optionValidator;
        this.activator = activator;
        if (renderer != null) {
            this.renderer = renderer;
        }
        this.defaultValues = defaultValue;
        this.properties = new HashMap<String, String>();
        this.values = new ArrayList<String>();
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean hasValue() {
        return this.optionType != OptionType.BOOLEAN;
    }

    public boolean hasMultipleValues() {
        return this.optionType == OptionType.LIST || this.optionType == OptionType.ARGUMENT;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean doOverrideRequired() {
        return this.overrideRequired;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public boolean isProperty() {
        return this.optionType == OptionType.GROUP;
    }

    public String getArgument() {
        return this.argument;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public OptionCompleter getCompleter() {
        return this.completer;
    }

    public OptionValidator getValidator() {
        return this.validator;
    }

    public OptionActivator getActivator() {
        return this.activator;
    }

    public OptionRenderer getRenderer() {
        return this.renderer;
    }

    public boolean isLongNameUsed() {
        return this.longNameUsed;
    }

    public void setLongNameUsed(boolean longNameUsed) {
        this.longNameUsed = longNameUsed;
    }

    public void setEndsWithSeparator(boolean endsWithSeparator) {
        this.endsWithSeparator = endsWithSeparator;
    }

    public boolean getEndsWithSeparator() {
        return this.endsWithSeparator;
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
        if (this.properties != null) {
            this.properties.clear();
        }
        this.longNameUsed = true;
        this.endsWithSeparator = false;
    }

    public String getDisplayName() {
        if (this.isLongNameUsed() && this.name != null) {
            return "--" + this.name;
        }
        if (this.shortName != null) {
            return "-" + this.shortName;
        }
        return null;
    }

    public TerminalString getRenderedNameWithDashes() {
        if (this.renderer == null || !this.ansiMode) {
            return new TerminalString("--" + this.name, true);
        }
        return new TerminalString("--" + this.name, this.renderer.getColor(), this.renderer.getTextType());
    }

    public int getFormattedLength() {
        StringBuilder sb = new StringBuilder();
        if (this.shortName != null) {
            sb.append("-").append(this.shortName);
        }
        if (this.name != null) {
            if (sb.toString().trim().length() > 0) {
                sb.append(", ");
            }
            sb.append("--").append(this.name);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        return sb.length();
    }

    public String getFormattedOption(int offset, int descriptionStart, int width) {
        StringBuilder sb = new StringBuilder();
        if (this.required && this.ansiMode) {
            sb.append(ANSI.BOLD);
        }
        if (offset > 0) {
            sb.append(String.format("%" + offset + "s", ""));
        }
        if (this.shortName != null) {
            sb.append("-").append(this.shortName);
        }
        if (this.name != null && this.name.length() > 0) {
            if (this.shortName != null) {
                sb.append(", ");
            }
            sb.append("--").append(this.name);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        if (this.required && this.ansiMode) {
            sb.append("\u001b[0;22m");
        }
        if (this.description != null && this.description.length() > 0) {
            int descOffset = descriptionStart - this.getFormattedLength() - offset;
            if (descOffset > 0) {
                sb.append(String.format("%" + descOffset + "s", ""));
            } else {
                sb.append(" ");
            }
            sb.append(this.description);
        }
        return sb.toString();
    }

    private Object doConvert(String inputValue, InvocationProviders invocationProviders, Object command, AeshContext aeshContext, boolean doValidation) throws OptionValidatorException {
        Object result = this.converter.convert(invocationProviders.getConverterProvider().enhanceConverterInvocation(new AeshConverterInvocation(inputValue, aeshContext)));
        if (this.validator != null && doValidation) {
            this.validator.validate(invocationProviders.getValidatorProvider().enhanceValidatorInvocation(new AeshValidatorInvocation<Object>(result, command, aeshContext)));
        }
        return result;
    }

    public void injectValueIntoField(Object instance, InvocationProviders invocationProviders, AeshContext aeshContext, boolean doValidation) throws OptionValidatorException {
        block32: {
            if (this.converter == null) {
                return;
            }
            try {
                Constructor<?> constructor;
                Field field = this.getField(instance.getClass(), this.fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                if (!Modifier.isPublic(instance.getClass().getModifiers()) && (constructor = instance.getClass().getDeclaredConstructor(new Class[0])) != null) {
                    constructor.setAccessible(true);
                }
                if (this.optionType == OptionType.NORMAL || this.optionType == OptionType.BOOLEAN) {
                    if (this.getValue() != null) {
                        field.set(instance, this.doConvert(this.getValue(), invocationProviders, instance, aeshContext, doValidation));
                    } else if (this.defaultValues.size() > 0) {
                        field.set(instance, this.doConvert(this.defaultValues.get(0), invocationProviders, instance, aeshContext, doValidation));
                    }
                    break block32;
                }
                if (this.optionType == OptionType.LIST || this.optionType == OptionType.ARGUMENT) {
                    if (field.getType().isInterface() || Modifier.isAbstract(field.getType().getModifiers())) {
                        if (Set.class.isAssignableFrom(field.getType())) {
                            HashSet<Object> tmpSet = new HashSet<Object>();
                            if (this.values.size() > 0) {
                                for (String in : this.values) {
                                    tmpSet.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                                }
                            } else if (this.defaultValues.size() > 0) {
                                for (String in : this.defaultValues) {
                                    tmpSet.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                                }
                            }
                            field.set(instance, tmpSet);
                            break block32;
                        }
                        if (!List.class.isAssignableFrom(field.getType())) break block32;
                        ArrayList<Object> tmpList = new ArrayList<Object>();
                        if (this.values.size() > 0) {
                            for (String in : this.values) {
                                tmpList.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                            }
                        } else if (this.defaultValues.size() > 0) {
                            for (String in : this.defaultValues) {
                                tmpList.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                            }
                        }
                        field.set(instance, tmpList);
                        break block32;
                    }
                    Collection tmpInstance = (Collection)field.getType().newInstance();
                    if (this.values.size() > 0) {
                        for (String in : this.values) {
                            tmpInstance.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                        }
                    } else if (this.defaultValues.size() > 0) {
                        for (String in : this.defaultValues) {
                            tmpInstance.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                        }
                    }
                    field.set(instance, tmpInstance);
                    break block32;
                }
                if (this.optionType == OptionType.GROUP) {
                    Map tmpMap;
                    if (field.getType().isInterface() || Modifier.isAbstract(field.getType().getModifiers())) {
                        tmpMap = this.newHashMap();
                        for (String propertyKey : this.properties.keySet()) {
                            tmpMap.put(propertyKey, this.doConvert(this.properties.get(propertyKey), invocationProviders, instance, aeshContext, doValidation));
                        }
                        field.set(instance, tmpMap);
                    } else {
                        tmpMap = (Map)field.getType().newInstance();
                        for (String propertyKey : this.properties.keySet()) {
                            tmpMap.put(propertyKey, this.doConvert(this.properties.get(propertyKey), invocationProviders, instance, aeshContext, doValidation));
                        }
                        field.set(instance, tmpMap);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateInvocationProviders(InvocationProviders invocationProviders) {
        this.activator = invocationProviders.getOptionActivatorProvider().enhanceOptionActivator(this.activator);
    }

    public void updateAnsiMode(boolean ansiMode) {
        this.ansiMode = ansiMode;
    }

    private <String, T> Map<String, T> newHashMap() {
        return new HashMap();
    }

    private Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                return this.getField(clazz.getSuperclass(), fieldName);
            }
            throw nsfe;
        }
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValues() != null && this.getDefaultValues().size() > 0;
    }

    public String toString() {
        return "ProcessedOption{shortName='" + this.shortName + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", values=" + this.values + ", defaultValues=" + this.defaultValues + ", argument='" + this.argument + '\'' + ", type=" + this.type + ", required=" + this.required + ", valueSeparator=" + this.valueSeparator + ", properties=" + this.properties + '}';
    }
}

