/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

public enum MetricUnit {
    NONE(""),
    PERCENTAGE("%"),
    BYTES("B"),
    KILOBYTES("KB"),
    MEGABYTES("MB"),
    GIGABYTES("GB"),
    TERABYTES("TB"),
    PETABYTES("PB"),
    BITS("b"),
    KILOBITS("Kb"),
    MEGABITS("Mb"),
    GIGABITS("Gb"),
    TERABITS("Tb"),
    PETABITS("Pb"),
    EPOCH_MILLISECONDS(""),
    EPOCH_SECONDS(""),
    JIFFYS("j"),
    NANOSECONDS("ns"),
    MICROSECONDS("us"),
    MILLISECONDS("ms"),
    SECONDS("s"),
    MINUTES("m"),
    HOURS("h"),
    DAYS("d"),
    PER_JIFFY("/j"),
    PER_NANOSECOND("/ns"),
    PER_MICROSECOND("/us"),
    PER_MILLISECOND("/ms"),
    PER_SECOND("/s"),
    PER_MINUTE("/m"),
    PER_HOUR("/h"),
    PER_DAY("/d"),
    CELSIUS("C"),
    KELVIN("K"),
    FAHRENHEIGHT("F");

    private final String displayName;

    private MetricUnit(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static MetricUnit fromDisplayName(String displayName) {
        for (MetricUnit mu : MetricUnit.values()) {
            if (!mu.displayName.equals(displayName)) continue;
            return mu;
        }
        throw new IllegalArgumentException("No such unit: " + displayName);
    }
}

