/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AccessAuthorizationCombinationPolicyWriteAttributeHandler;
import org.jboss.as.domain.management.access.AccessAuthorizationProviderWriteAttributeHander;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.dmr.ModelNode;

public class AccessAuthorizationDomainSlaveConfigHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "configure-from-domain";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("configure-from-domain", DomainManagementResolver.getResolver("core.access-control")).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setPrivateEntry().build();
    private final DelegatingConfigurableAuthorizer configurableAuthorizer;

    AccessAuthorizationDomainSlaveConfigHandler(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        this.configurableAuthorizer = configurableAuthorizer;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        for (AttributeDefinition ad : AccessAuthorizationResourceDefinition.CONFIG_ATTRIBUTES) {
            ad.validateAndSet(operation, model);
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                WritableAuthorizerConfiguration authorizerConfiguration = AccessAuthorizationDomainSlaveConfigHandler.this.configurableAuthorizer.getWritableAuthorizerConfiguration();
                ModelNode provider = AccessAuthorizationResourceDefinition.PROVIDER.resolveModelAttribute(context, model);
                AccessAuthorizationProviderWriteAttributeHander.updateAuthorizer(provider, AccessAuthorizationDomainSlaveConfigHandler.this.configurableAuthorizer);
                ModelNode combinationPolicy = AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.resolveModelAttribute(context, model);
                AccessAuthorizationCombinationPolicyWriteAttributeHandler.updateAuthorizer(combinationPolicy, authorizerConfiguration);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

