/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.remotingjmx.RemotingConnector;
import org.jboss.remotingjmx.Version;

public class RemotingConnectorProvider
implements JMXConnectorProvider {
    private static final Logger log = Logger.getLogger(RemotingConnectorProvider.class);

    @Override
    public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        String protocol;
        switch (protocol = serviceURL.getProtocol()) {
            case "remote": 
            case "remoting-jmx": 
            case "remote+http": 
            case "http-remoting-jmx": 
            case "remote+https": 
            case "https-remoting-jmx": {
                return new RemotingConnector(serviceURL, environment);
            }
        }
        log.tracef("Protocol (%s) not recognised by this provider.", (Object)protocol);
        return null;
    }

    public static String getVersionString() {
        return Version.getVersionString();
    }
}

