/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.SubclassedComponentDescriptor;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbDescriptor;
import org.jboss.weld.util.reflection.Reflections;

public class InternalEjbDescriptor<T>
extends ForwardingEjbDescriptor<T> {
    private final Class<?> objectInterface;
    private final EjbDescriptor<T> delegate;
    private final Collection<MethodSignature> removeMethodSignatures;
    private final Set<Class<?>> localBusinessInterfaces;
    private final Set<Class<?>> remoteBusinessInterfaces;

    public static <T> InternalEjbDescriptor<T> of(EjbDescriptor<T> ejbDescriptor) {
        if (ejbDescriptor instanceof InternalEjbDescriptor) {
            return (InternalEjbDescriptor)((Object)Reflections.cast(ejbDescriptor));
        }
        return new InternalEjbDescriptor<T>(ejbDescriptor);
    }

    private InternalEjbDescriptor(EjbDescriptor<T> ejbDescriptor) {
        this.delegate = ejbDescriptor;
        this.objectInterface = InternalEjbDescriptor.findObjectInterface(ejbDescriptor.getLocalBusinessInterfaces());
        this.removeMethodSignatures = new ArrayList<MethodSignature>();
        if (ejbDescriptor.getRemoveMethods() != null) {
            for (Method method : ejbDescriptor.getRemoveMethods()) {
                this.removeMethodSignatures.add(new MethodSignatureImpl(method));
            }
        }
        this.localBusinessInterfaces = InternalEjbDescriptor.transformToClasses(this.getLocalBusinessInterfaces());
        this.remoteBusinessInterfaces = InternalEjbDescriptor.transformToClasses(this.getRemoteBusinessInterfaces());
    }

    private static Set<Class<?>> transformToClasses(Collection<BusinessInterfaceDescriptor<?>> interfaceDescriptors) {
        if (interfaceDescriptors == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Collection)Collections2.transform(interfaceDescriptors, (Function)BusinessInterfaceDescriptorToClassFunction.INSTANCE));
    }

    public EjbDescriptor<T> delegate() {
        return this.delegate;
    }

    public Class<?> getObjectInterface() {
        return this.objectInterface;
    }

    public Collection<MethodSignature> getRemoveMethodSignatures() {
        return this.removeMethodSignatures;
    }

    private static Class<?> findObjectInterface(Collection<BusinessInterfaceDescriptor<?>> interfaces) {
        if (interfaces != null && !interfaces.isEmpty()) {
            return interfaces.iterator().next().getInterface();
        }
        return null;
    }

    public Set<Class<?>> getLocalBusinessInterfacesAsClasses() {
        return this.localBusinessInterfaces;
    }

    public Set<Class<?>> getRemoteBusinessInterfacesAsClasses() {
        return this.remoteBusinessInterfaces;
    }

    public Class<? extends T> getImplementationClass() {
        SubclassedComponentDescriptor descriptor;
        Class implementationClass;
        if (this.delegate instanceof SubclassedComponentDescriptor && (implementationClass = (descriptor = (SubclassedComponentDescriptor)Reflections.cast(this.delegate)).getComponentSubclass()) != null) {
            return implementationClass;
        }
        return this.delegate.getBeanClass();
    }

    private static class BusinessInterfaceDescriptorToClassFunction
    implements Function<BusinessInterfaceDescriptor<?>, Class<?>> {
        private static final BusinessInterfaceDescriptorToClassFunction INSTANCE = new BusinessInterfaceDescriptorToClassFunction();

        private BusinessInterfaceDescriptorToClassFunction() {
        }

        public Class<?> apply(BusinessInterfaceDescriptor<?> input) {
            return input.getInterface();
        }
    }
}

