/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.api;

import java.util.Collections;
import java.util.Map;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.inventory.AvailManager;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;

public class AvailEvent<L> {
    private final SamplingService<L> samplingService;
    private final AvailManager<L> availManager;
    private final Map<MeasurementInstance<L, AvailType<L>>, Avail> started;
    private final Map<MeasurementInstance<L, AvailType<L>>, Avail> changed;

    private AvailEvent(SamplingService<L> samplingService, AvailManager<L> availManager, Map<MeasurementInstance<L, AvailType<L>>, Avail> started, Map<MeasurementInstance<L, AvailType<L>>, Avail> changed) {
        if (samplingService == null) {
            throw new IllegalArgumentException("Sampling service cannot be null");
        }
        if (availManager == null) {
            throw new IllegalArgumentException("Avail manager cannot be null");
        }
        this.samplingService = samplingService;
        this.availManager = availManager;
        this.changed = changed;
        this.started = started;
    }

    public static <L> AvailEvent<L> availChanged(SamplingService<L> samplingService, AvailManager<L> availManager, Map<MeasurementInstance<L, AvailType<L>>, Avail> changed) {
        return new AvailEvent<L>(samplingService, availManager, Collections.emptyMap(), changed);
    }

    public static <L> AvailEvent<L> availStarted(SamplingService<L> samplingService, AvailManager<L> availManager, Map<MeasurementInstance<L, AvailType<L>>, Avail> started) {
        return new AvailEvent<L>(samplingService, availManager, started, Collections.emptyMap());
    }

    public SamplingService<L> getSamplingService() {
        return this.samplingService;
    }

    public AvailManager<L> getAvailManager() {
        return this.availManager;
    }

    public Map<MeasurementInstance<L, AvailType<L>>, Avail> getChanged() {
        return this.changed;
    }

    public Map<MeasurementInstance<L, AvailType<L>>, Avail> getStarted() {
        return this.started;
    }
}

